/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.template;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.sequence.template.ModelGeneratedMaker;
import org.eclipse.sirius.diagram.sequence.template.TTransformer;
import org.eclipse.sirius.diagram.sequence.template.Transformer;

public abstract class AbstractRule<F extends TTransformer, T extends EObject>
implements Transformer<F, T> {
    private ModelGeneratedMaker marker;

    public AbstractRule(ModelGeneratedMaker marker) {
        this.marker = marker;
    }

    public T get(F from, EClass expected) {
        for (EObject out : from.getOutputs()) {
            if (out.eClass() != expected) continue;
            return (T)out;
        }
        return null;
    }

    protected T getOrCreate(TTransformer from, EClass outputType) {
        Object existing = this.get(from, outputType);
        if (existing == null) {
            existing = EcoreUtil.create((EClass)outputType);
            this.marker.markGenerated((EObject)existing);
            from.getOutputs().add(existing);
        }
        return existing;
    }

    public EObject getEObject(TTransformer from, EClass expected) {
        for (EObject out : from.getOutputs()) {
            if (out.eClass() != expected) continue;
            return out;
        }
        return null;
    }

    public static Collection<EObject> collectGeneratedElements(AbstractRule<?, ?> rule, EClass expected, List<? extends EObject> source) {
        ArrayList found = Lists.newArrayList();
        for (TTransformer srcElement : Iterables.filter(source, TTransformer.class)) {
            EObject transformed = rule.getEObject(srcElement, expected);
            if (transformed == null) continue;
            found.add(transformed);
        }
        return found;
    }

    public static <FC, TC> Collection<TC> transform(Collection<FC> fromCollection, final Transformer<? super FC, TC> transformer) {
        return Collections2.transform(fromCollection, (Function)new Function<FC, TC>(){

            public TC apply(FC input) {
                return transformer.apply(input);
            }
        });
    }
}

