/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.filesystem.LogEntryCache;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;

class RLogTreeBuilder {
    private ICVSRepositoryLocation location;
    private RemoteFolderTree tree;
    private CVSTag tag;
    private HashMap folderMap;
    private HashMap logMap;
    private LogEntryCache cache;

    public RLogTreeBuilder(ICVSRepositoryLocation location, CVSTag tag, LogEntryCache cache) {
        this.tag = tag;
        this.location = location;
        this.cache = cache;
        this.reset();
    }

    public RemoteFolderTree getTree() {
        return this.tree;
    }

    public void reset() {
        this.folderMap = new HashMap(16);
        this.logMap = new HashMap(16);
        this.tree = new RemoteFolderTree(null, this.location, "", this.tag);
        this.tree.setChildren(new ICVSRemoteResource[0]);
    }

    public void newFile(IPath remoteFilePath, ICVSRemoteFile remoteFile) {
        try {
            this.addFile(this.tree, this.tag, remoteFile, remoteFilePath);
        }
        catch (CVSException cVSException) {}
    }

    private void addFile(RemoteFolderTree tree, CVSTag tag, ICVSRemoteFile file, IPath filePath) throws CVSException {
        RemoteFolderTree parent = (RemoteFolderTree)this.getFolder(tree, tag, filePath.removeLastSegments(1), (IPath)Path.EMPTY);
        this.addChild(parent, file);
    }

    private void addChild(RemoteFolderTree tree, ICVSRemoteResource resource) {
        ICVSRemoteResource[] newChildren;
        this.logMap.put(resource, this.cache.getLogEntry(resource));
        ICVSRemoteResource[] children = tree.getChildren();
        if (children == null) {
            newChildren = new ICVSRemoteResource[]{resource};
        } else {
            newChildren = new ICVSRemoteResource[children.length + 1];
            System.arraycopy(children, 0, newChildren, 0, children.length);
            newChildren[children.length] = resource;
        }
        tree.setChildren(newChildren);
    }

    private ICVSRemoteFolder getFolder(RemoteFolderTree tree, CVSTag tag, IPath remoteFolderPath, IPath parentPath) throws CVSException {
        ICVSResource child;
        if (remoteFolderPath.segmentCount() == 0) {
            return tree;
        }
        String name = remoteFolderPath.segment(0);
        IPath childPath = parentPath.append(name);
        if (tree.childExists(name)) {
            child = tree.getChild(name);
        } else {
            child = new RemoteFolderTree(tree, tree.getRepository(), childPath.toString(), tag);
            this.folderMap.put(childPath.toString(), child);
            ((RemoteFolderTree)child).setChildren(new ICVSRemoteResource[0]);
            this.addChild(tree, (ICVSRemoteResource)child);
        }
        return this.getFolder((RemoteFolderTree)child, tag, remoteFolderPath.removeFirstSegments(1), childPath);
    }

    public HashMap getFolderMap() {
        return this.folderMap;
    }

    public HashMap getLogMap() {
        return this.logMap;
    }
}

