/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPath;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPathWithRevision;
import org.eclipse.team.svn.revision.graph.cache.CacheRevision;
import org.eclipse.team.svn.revision.graph.cache.CopyToHelper;
import org.eclipse.team.svn.revision.graph.cache.MergeInfoStorage;
import org.eclipse.team.svn.revision.graph.cache.MessageStorage;
import org.eclipse.team.svn.revision.graph.cache.PathStorage;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheReadHelper;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheWriteHelper;
import org.eclipse.team.svn.revision.graph.cache.StringStorage;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCache {
    public static final int UNKNOWN_INDEX = -1;
    protected final File cacheFile;
    protected final RepositoryCacheInfo cacheInfo;
    protected int cacheVersion = 2;
    protected CacheRevision[] revisions = new CacheRevision[0];
    protected PathStorage pathStorage;
    protected StringStorage authors;
    protected MessageStorage messages;
    protected CopyToHelper copyToContainer = new CopyToHelper();
    protected MergeInfoStorage mergeInfo;
    protected boolean isDirty;
    protected RepositoryCacheWriteHelper writeHelper;
    protected RepositoryCacheReadHelper readHelper;

    public RepositoryCache(File cacheFile, RepositoryCacheInfo cacheInfo) {
        this.cacheFile = cacheFile;
        this.cacheInfo = cacheInfo;
    }

    public RepositoryCacheInfo getCacheInfo() {
        return this.cacheInfo;
    }

    public void expandRevisionsCount(long revisionsCount) {
        if (++revisionsCount < (long)this.revisions.length) {
            throw new IllegalArgumentException("Revisions: " + revisionsCount + ", size: " + this.revisions.length);
        }
        if (this.revisions.length != 0) {
            CacheRevision[] tmp = this.revisions;
            this.revisions = new CacheRevision[(int)revisionsCount];
            System.arraycopy(tmp, 0, this.revisions, 0, tmp.length);
        } else {
            this.revisions = new CacheRevision[(int)revisionsCount];
        }
        this.messages.expandMessagesCount(revisionsCount);
    }

    public long getLastProcessedRevision() {
        return this.cacheInfo.getLastProcessedRevision();
    }

    public List<CacheRevision> getRevisionsWithoutNulls() {
        ArrayList<CacheRevision> revisionsList = new ArrayList<CacheRevision>();
        CacheRevision[] cacheRevisionArray = this.revisions;
        int n = this.revisions.length;
        int n2 = 0;
        while (n2 < n) {
            CacheRevision revision = cacheRevisionArray[n2];
            if (revision != null) {
                revisionsList.add(revision);
            }
            ++n2;
        }
        return revisionsList;
    }

    public CacheRevision getRevision(long revision) {
        if (revision < (long)this.revisions.length) {
            return this.revisions[(int)revision];
        }
        return null;
    }

    public PathStorage getPathStorage() {
        return this.pathStorage;
    }

    public StringStorage getAuthorStorage() {
        return this.authors;
    }

    public MessageStorage getMessageStorage() {
        return this.messages;
    }

    public MergeInfoStorage getMergeInfoStorage() {
        return this.mergeInfo;
    }

    public List<CacheChangedPathWithRevision> getCopiedToData(int pathId) {
        List<CacheChangedPathWithRevision> res = this.copyToContainer.getCopyTo(pathId);
        return res != null ? new ArrayList<CacheChangedPathWithRevision>(res) : Collections.emptyList();
    }

    public int getCacheVersion() {
        return this.cacheVersion;
    }

    protected CacheRevision convert(SVNLogEntry entry) {
        CacheChangedPath[] changedPaths;
        if (entry.changedPaths != null && entry.changedPaths.length > 0) {
            changedPaths = new CacheChangedPath[entry.changedPaths.length];
            int i = 0;
            while (i < entry.changedPaths.length) {
                changedPaths[i] = this.convert(entry.changedPaths[i], entry.revision);
                ++i;
            }
        } else {
            changedPaths = new CacheChangedPath[]{};
        }
        int authorIndex = entry.author != null ? this.authors.add(entry.author) : -1;
        int messageIndex = this.messages.add(entry.message, entry.revision);
        CacheRevision revision = new CacheRevision(entry.revision, authorIndex, entry.date, messageIndex, changedPaths);
        return revision;
    }

    protected CacheChangedPath convert(SVNLogPath logPath, long revision) {
        int pathIndex = this.pathStorage.add(logPath.path);
        int copiedFromPathIndex = this.pathStorage.add(logPath.copiedFromPath);
        CacheChangedPath changedPath = new CacheChangedPath(pathIndex, logPath.action, copiedFromPathIndex, logPath.copiedFromRevision);
        return changedPath;
    }

    protected void initCopyToData() {
        this.copyToContainer.clear();
        CacheRevision[] cacheRevisionArray = this.revisions;
        int n = this.revisions.length;
        int n2 = 0;
        while (n2 < n) {
            CacheRevision cacheRevision = cacheRevisionArray[n2];
            if (cacheRevision != null) {
                CacheChangedPath[] cacheChangedPathArray = cacheRevision.getChangedPaths();
                int n3 = cacheChangedPathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CacheChangedPath cp = cacheChangedPathArray[n4];
                    if (cp.copiedFromPathIndex != -1) {
                        this.copyToContainer.add(cp, cacheRevision.getRevision());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void prepareModel() {
        this.initCopyToData();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addEntry(SVNLogEntry entry) {
        CacheRevision revisionStructure;
        this.revisions[(int)revisionStructure.revision] = revisionStructure = this.convert(entry);
        this.isDirty = true;
    }

    public void addMergeInfo(SVNLogEntry entryWithMerges) {
        SVNLogEntry[] children = entryWithMerges.getChildren();
        if (children != null && children.length > 0) {
            long[] mergeRevs = new long[children.length];
            int i = 0;
            while (i < children.length) {
                mergeRevs[i] = children[i].revision;
                ++i;
            }
            this.mergeInfo.addMergeInfo(entryWithMerges.revision, mergeRevs);
            this.isDirty = true;
        }
    }

    public void save(IProgressMonitor monitor) throws IOException {
        if (this.writeHelper == null) {
            this.writeHelper = new RepositoryCacheWriteHelper(this);
        }
        TimeMeasure compressMeasure = new TimeMeasure("Compress messages");
        this.messages.compress();
        compressMeasure.end();
        TimeMeasure saveMeasure = new TimeMeasure("Save measure");
        this.writeHelper.save();
        saveMeasure.end();
        this.cacheInfo.save();
        this.isDirty = false;
    }

    public void load(IProgressMonitor monitor) throws IOException {
        this.pathStorage = new PathStorage();
        this.authors = new StringStorage();
        this.mergeInfo = new MergeInfoStorage();
        long lastProcessedRevision = this.cacheInfo.getLastProcessedRevision();
        if (lastProcessedRevision == 0L) {
            this.revisions = new CacheRevision[0];
            this.messages = new MessageStorage(0);
        } else {
            this.revisions = new CacheRevision[(int)lastProcessedRevision + 1];
            this.messages = new MessageStorage((int)lastProcessedRevision + 1);
            if (this.readHelper == null) {
                this.readHelper = new RepositoryCacheReadHelper(this);
            }
            this.readHelper.load();
        }
        this.isDirty = false;
    }
}

