/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.inputoutput;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DisksIODataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    protected static final String PROVIDER_TITLE = Objects.requireNonNull(Messages.DisksIODataProvider_title);
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.DisksIODataProvider";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final InputOutputAnalysisModule fModule;
    private final BiMap<Long, Integer> fIdToSectorQuark = HashBiMap.create();
    private @Nullable TmfModelResponse<List<TmfTreeDataModel>> fCached = null;
    private final long fTraceId = ENTRY_ID.getAndIncrement();

    public static @Nullable DisksIODataProvider create(ITmfTrace trace) {
        InputOutputAnalysisModule module = (InputOutputAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, InputOutputAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.inputoutput");
        if (module != null) {
            module.schedule();
            return new DisksIODataProvider(trace, module);
        }
        return null;
    }

    private DisksIODataProvider(ITmfTrace trace, InputOutputAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    public String getId() {
        return ID;
    }

    public TmfModelResponse<List<TmfTreeDataModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        if (this.fCached != null) {
            return this.fCached;
        }
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        boolean complete = ss.waitUntilBuilt(0L);
        ArrayList<TmfTreeDataModel> nodes = new ArrayList<TmfTreeDataModel>();
        nodes.add(new TmfTreeDataModel(this.fTraceId, -1L, this.getTrace().getName()));
        String readName = Objects.requireNonNull(Messages.DisksIODataProvider_read);
        String writeName = Objects.requireNonNull(Messages.DisksIODataProvider_write);
        for (Integer diskQuark : ss.getQuarks(new String[]{"Disks", "*"})) {
            int writeQuark;
            String diskName = DisksIODataProvider.getDiskName(ss, diskQuark);
            long diskId = this.getId(diskQuark);
            nodes.add(new TmfTreeDataModel(diskId, this.fTraceId, diskName));
            int readQuark = ss.optQuarkRelative(diskQuark.intValue(), new String[]{"sectors_read"});
            if (readQuark != -2) {
                nodes.add(new TmfTreeDataModel(this.getId(readQuark), diskId, readName));
            }
            if ((writeQuark = ss.optQuarkRelative(diskQuark.intValue(), new String[]{"sectors_written"})) == -2) continue;
            nodes.add(new TmfTreeDataModel(this.getId(writeQuark), diskId, writeName));
        }
        if (complete) {
            TmfModelResponse response;
            this.fCached = response = new TmfModelResponse(nodes, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            return response;
        }
        return new TmfModelResponse(nodes, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    private long getId(int quark) {
        Long id = (Long)this.fIdToSectorQuark.inverse().get((Object)quark);
        if (id == null) {
            id = ENTRY_ID.getAndIncrement();
            this.fIdToSectorQuark.put((Object)id, (Object)quark);
        }
        return id;
    }

    private static String getDiskName(ITmfStateSystem ss, Integer diskQuark) {
        ITmfStateInterval interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)diskQuark, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        if (interval != null) {
            return String.valueOf(interval.getValue());
        }
        int devNum = Integer.parseInt(ss.getAttributeName(diskQuark.intValue()));
        return Disk.extractDeviceIdString(devNum);
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        @NonNull ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        long[] xValues = filter.getTimesRequested();
        List<DiskBuilder> builders = this.initBuilders(ss, filter);
        if (builders.isEmpty()) {
            return TmfCommonXAxisResponseFactory.create((String)PROVIDER_TITLE, (long[])xValues, Collections.emptyMap(), (boolean)true);
        }
        long currentEnd = ss.getCurrentEndTime();
        try {
            long prevTime = filter.getStart();
            if (prevTime >= ss.getStartTime() && prevTime <= currentEnd) {
                List states = ss.queryFullState(prevTime);
                for (DiskBuilder entry : builders) {
                    entry.setPrevCount(Disk.extractCount(entry.fSectorQuark, ss, states, prevTime));
                }
            }
            int i = 1;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time > currentEnd) break;
                if (time >= ss.getStartTime()) {
                    List states = ss.queryFullState(time);
                    for (DiskBuilder entry : builders) {
                        double count = Disk.extractCount(entry.fSectorQuark, ss, states, time);
                        entry.updateValue(i, count, time - prevTime);
                    }
                }
                prevTime = time;
                ++i;
            }
            ImmutableMap.Builder ySeries = ImmutableMap.builder();
            for (DiskBuilder entry : builders) {
                IYModel model = entry.build();
                ySeries.put((Object)model.getName(), (Object)model);
            }
            boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
            return TmfCommonXAxisResponseFactory.create((String)PROVIDER_TITLE, (long[])xValues, (Map)ySeries.build(), (boolean)complete);
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
    }

    private List<DiskBuilder> initBuilders(ITmfStateSystem ss, TimeQueryFilter filter) {
        if (!(filter instanceof SelectionTimeQueryFilter)) {
            return Collections.emptyList();
        }
        int length = filter.getTimesRequested().length;
        ArrayList<DiskBuilder> builders = new ArrayList<DiskBuilder>();
        for (Long id : ((SelectionTimeQueryFilter)filter).getSelectedItems()) {
            String name;
            Integer quark = (Integer)this.fIdToSectorQuark.get((Object)id);
            if (quark == null) continue;
            if (ss.getAttributeName(quark.intValue()).equals("sectors_read")) {
                name = String.valueOf(this.getTrace().getName()) + '/' + DisksIODataProvider.getDiskName(ss, ss.getParentAttributeQuark(quark.intValue())) + "/read";
                builders.add(new DiskBuilder(quark, name, length));
                continue;
            }
            if (!ss.getAttributeName(quark.intValue()).equals("sectors_written")) continue;
            name = String.valueOf(this.getTrace().getName()) + '/' + DisksIODataProvider.getDiskName(ss, ss.getParentAttributeQuark(quark.intValue())) + "/write";
            builders.add(new DiskBuilder(quark, name, length));
        }
        return builders;
    }

    private static final class DiskBuilder {
        private static final int BYTES_PER_SECTOR = 512;
        private static final double SECONDS_PER_NANOSECOND = 1.0E-8;
        private static final double RATIO = 5.12E10;
        public final int fSectorQuark;
        private final String fName;
        private final double[] fValues;
        private double fPrevCount;

        private DiskBuilder(int sectorQuark, String name, int length) {
            this.fSectorQuark = sectorQuark;
            this.fName = name;
            this.fValues = new double[length];
        }

        private void setPrevCount(double prevCount) {
            this.fPrevCount = prevCount;
        }

        private void updateValue(int pos, double newCount, long deltaT) {
            this.fValues[pos] = (newCount - this.fPrevCount) * 5.12E10 / (double)deltaT;
            this.fPrevCount = newCount;
        }

        private IYModel build() {
            return new YModel(this.fName, this.fValues);
        }
    }
}

