/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class SafeMappedByteBuffer {
    private static final boolean IS_WIN32 = System.getProperty("os.name").startsWith("Windows");

    private SafeMappedByteBuffer() {
    }

    public static ByteBuffer map(FileChannel fc, FileChannel.MapMode mode, long position, long size) throws IOException {
        ByteBuffer byteBuffer;
        if (IS_WIN32) {
            byteBuffer = ByteBuffer.allocate((int)size);
            fc.read(byteBuffer, position);
            byteBuffer.flip();
        } else {
            byteBuffer = fc.map(mode, position, size);
        }
        return byteBuffer;
    }
}

