/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;

public class LttngEventLayout
implements IKernelAnalysisEventLayout {
    private static final String IRQ_HANDLER_ENTRY = "irq_handler_entry";
    private static final String IRQ_HANDLER_EXIT = "irq_handler_exit";
    private static final String SOFTIRQ_ENTRY = "softirq_entry";
    private static final String SOFTIRQ_EXIT = "softirq_exit";
    private static final String SOFTIRQ_RAISE = "softirq_raise";
    private static final String HRTIMER_START = "hrtimer_start";
    private static final String HRTIMER_CANCEL = "hrtimer_cancel";
    private static final String HRTIMER_EXPIRE_ENTRY = "hrtimer_expire_entry";
    private static final String HRTIMER_EXPIRE_EXIT = "hrtimer_expire_exit";
    private static final String SCHED_SWITCH = "sched_switch";
    private static final String SCHED_PI_SETPRIO = "sched_pi_setprio";
    private static final String SCHED_TTWU = "sched_ttwu";
    private static final String SCHED_WAKEUP = "sched_wakeup";
    private static final String SCHED_WAKEUP_NEW = "sched_wakeup_new";
    private static final Collection<String> SCHED_WAKEUP_EVENTS = ImmutableList.of((Object)"sched_wakeup", (Object)"sched_wakeup_new");
    private static final String SCHED_PROCESS_FORK = "sched_process_fork";
    private static final String SCHED_PROCESS_EXIT = "sched_process_exit";
    private static final String SCHED_PROCESS_FREE = "sched_process_free";
    private static final String SCHED_PROCESS_EXEC = "sched_process_exec";
    private static final String STATEDUMP_PROCESS_STATE = "lttng_statedump_process_state";
    private static final String SYSCALL_ENTRY_PREFIX = "sys_";
    private static final String COMPAT_SYSCALL_ENTRY_PREFIX = "compat_sys_";
    private static final String SYSCALL_EXIT_PREFIX = "exit_syscall";
    private static final String BLOCK_RQ_INSERT = "block_rq_insert";
    private static final String BLOCK_RQ_ISSUE = "block_rq_issue";
    private static final String ELV_MERGE_REQUESTS = "addons_elv_merge_requests";
    private static final String BLOCK_RQ_COMPLETE = "block_rq_complete";
    private static final String LTTNG_STATEDUMP_BLOCK_DEVICE = "lttng_statedump_block_device";
    private static final String BLOCK_BIO_FRONTMERGE = "block_bio_frontmerge";
    private static final String BLOCK_BIO_BACKMERGE = "block_bio_backmerge";
    private static final String IRQ = "irq";
    private static final String TID = "tid";
    private static final String VEC = "vec";
    private static final String PREV_TID = "prev_tid";
    private static final String PREV_STATE = "prev_state";
    private static final String NEXT_COMM = "next_comm";
    private static final String NEXT_TID = "next_tid";
    private static final String PARENT_TID = "parent_tid";
    private static final String CHILD_COMM = "child_comm";
    private static final String CHILD_TID = "child_tid";
    private static final String PRIO = "prio";
    private static final String PREV_PRIO = "prev_prio";
    private static final String NEXT_PRIO = "next_prio";
    private static final String NEW_PRIO = "newprio";
    private static final String COMM = "comm";
    private static final String NAME = "name";
    private static final String STATUS = "status";
    private static final String PREV_COMM = "prev_comm";
    private static final String FILENAME = "filename";
    private static final String HRTIMER = "hrtimer";
    private static final String HRTIMER_FUNCTION = "function";
    private static final String HRTIMER_EXPIRES = "expires";
    private static final String HRTIMER_NOW = "now";
    private static final String HRTIMER_SOFT_EXPIRES = "softexpires";
    private static final String KMEM_ALLOC = "mm_page_alloc";
    private static final String KMEM_FREE = "mm_page_free";
    private static final String SYSCALL_RET = "ret";
    private static final String RWBS = "rwbs";
    private static final String DISKNAME = "diskname";
    private static final String BLOCK_DEV = "dev";
    private static final String SECTOR = "sector";
    private static final String NR_SECTOR = "nr_sector";
    private static final String RQ_SECTOR = "rq_sector";
    private static final String NEXTRQ_SECTOR = "nextrq_sector";
    private static final String ORDER = "order";
    private static final Collection<String> EVENTS_NETWORK_SEND = Collections.singleton("net_dev_queue");
    private static final Collection<String> EVENTS_NETWORK_RECEIVE = Collections.singleton("netif_receive_skb");
    private static final String[] TCP_SEQ_FIELD = new String[]{"transport_fields", "thtype_tcp", "seq"};
    private static final String[] TCP_ACK_FIELD = new String[]{"transport_fields", "thtype_tcp", "ack_seq"};
    private static final String[] TCP_FLAGS_FIELD = new String[]{"transport_fields", "thtype_tcp", "flags"};
    private static final Collection<String> KVM_ENTRY_EVENTS = Collections.singleton("kvm_entry");
    private static final Collection<String> KVM_EXIT_EVENTS = Collections.singleton("kvm_exit");
    private static final IKernelAnalysisEventLayout INSTANCE = new LttngEventLayout();

    protected LttngEventLayout() {
    }

    public static IKernelAnalysisEventLayout getInstance() {
        return INSTANCE;
    }

    public String eventIrqHandlerEntry() {
        return IRQ_HANDLER_ENTRY;
    }

    public String eventIrqHandlerExit() {
        return IRQ_HANDLER_EXIT;
    }

    public String eventSoftIrqEntry() {
        return SOFTIRQ_ENTRY;
    }

    public String eventSoftIrqExit() {
        return SOFTIRQ_EXIT;
    }

    public String eventSoftIrqRaise() {
        return SOFTIRQ_RAISE;
    }

    public String eventSchedSwitch() {
        return SCHED_SWITCH;
    }

    public String eventSchedPiSetprio() {
        return SCHED_PI_SETPRIO;
    }

    public Collection<String> eventsSchedWakeup() {
        return SCHED_WAKEUP_EVENTS;
    }

    public String eventSchedProcessFork() {
        return SCHED_PROCESS_FORK;
    }

    public String eventSchedProcessExit() {
        return SCHED_PROCESS_EXIT;
    }

    public String eventSchedProcessFree() {
        return SCHED_PROCESS_FREE;
    }

    public @NonNull String eventStatedumpProcessState() {
        return STATEDUMP_PROCESS_STATE;
    }

    public String eventSyscallEntryPrefix() {
        return SYSCALL_ENTRY_PREFIX;
    }

    public String eventCompatSyscallEntryPrefix() {
        return COMPAT_SYSCALL_ENTRY_PREFIX;
    }

    public String eventSyscallExitPrefix() {
        return SYSCALL_EXIT_PREFIX;
    }

    public String eventCompatSyscallExitPrefix() {
        return SYSCALL_EXIT_PREFIX;
    }

    public String eventKmemPageAlloc() {
        return KMEM_ALLOC;
    }

    public String eventKmemPageFree() {
        return KMEM_FREE;
    }

    public String fieldIrq() {
        return IRQ;
    }

    public String fieldVec() {
        return VEC;
    }

    public String fieldTid() {
        return TID;
    }

    public String fieldPrevTid() {
        return PREV_TID;
    }

    public String fieldPrevState() {
        return PREV_STATE;
    }

    public String fieldNextComm() {
        return NEXT_COMM;
    }

    public String fieldNextTid() {
        return NEXT_TID;
    }

    public String fieldChildComm() {
        return CHILD_COMM;
    }

    public String fieldParentTid() {
        return PARENT_TID;
    }

    public String fieldChildTid() {
        return CHILD_TID;
    }

    public String fieldPrio() {
        return PRIO;
    }

    public String fieldNewPrio() {
        return NEW_PRIO;
    }

    public String fieldPrevPrio() {
        return PREV_PRIO;
    }

    public String fieldNextPrio() {
        return NEXT_PRIO;
    }

    public String fieldComm() {
        return COMM;
    }

    public String fieldName() {
        return NAME;
    }

    public String fieldStatus() {
        return STATUS;
    }

    public String fieldPrevComm() {
        return PREV_COMM;
    }

    public String fieldFilename() {
        return FILENAME;
    }

    public String eventSchedProcessExec() {
        return SCHED_PROCESS_EXEC;
    }

    public String eventSchedProcessWakeup() {
        return SCHED_WAKEUP;
    }

    public String eventSchedProcessWakeupNew() {
        return SCHED_WAKEUP_NEW;
    }

    public String eventHRTimerStart() {
        return HRTIMER_START;
    }

    public String eventHRTimerCancel() {
        return HRTIMER_CANCEL;
    }

    public String eventHRTimerExpireEntry() {
        return HRTIMER_EXPIRE_ENTRY;
    }

    public String eventHRTimerExpireExit() {
        return HRTIMER_EXPIRE_EXIT;
    }

    public String eventSchedProcessTTWU() {
        return SCHED_TTWU;
    }

    public String fieldHRtimer() {
        return HRTIMER;
    }

    public String fieldHRtimerFunction() {
        return HRTIMER_FUNCTION;
    }

    public String fieldHRtimerExpires() {
        return HRTIMER_EXPIRES;
    }

    public String fieldHRtimerSoftexpires() {
        return HRTIMER_SOFT_EXPIRES;
    }

    public String fieldHRtimerNow() {
        return HRTIMER_NOW;
    }

    public String fieldSyscallRet() {
        return SYSCALL_RET;
    }

    public String eventBlockRqInsert() {
        return BLOCK_RQ_INSERT;
    }

    public String eventBlockRqIssue() {
        return BLOCK_RQ_ISSUE;
    }

    public String eventBlockRqComplete() {
        return BLOCK_RQ_COMPLETE;
    }

    public String eventBlockBioFrontmerge() {
        return BLOCK_BIO_FRONTMERGE;
    }

    public String eventBlockBioBackmerge() {
        return BLOCK_BIO_BACKMERGE;
    }

    public String eventBlockRqMerge() {
        return ELV_MERGE_REQUESTS;
    }

    public @NonNull String eventStatedumpBlockDevice() {
        return LTTNG_STATEDUMP_BLOCK_DEVICE;
    }

    public String fieldBlockDeviceId() {
        return BLOCK_DEV;
    }

    public String fieldBlockSector() {
        return SECTOR;
    }

    public String fieldBlockNrSector() {
        return NR_SECTOR;
    }

    public String fieldBlockRwbs() {
        return RWBS;
    }

    public String fieldBlockRqSector() {
        return RQ_SECTOR;
    }

    public String fieldBlockNextRqSector() {
        return NEXTRQ_SECTOR;
    }

    public String fieldDiskname() {
        return DISKNAME;
    }

    public Collection<String> eventsNetworkSend() {
        return EVENTS_NETWORK_SEND;
    }

    public Collection<String> eventsNetworkReceive() {
        return EVENTS_NETWORK_RECEIVE;
    }

    public String @NonNull [] fieldPathTcpSeq() {
        return TCP_SEQ_FIELD;
    }

    public String @NonNull [] fieldPathTcpAckSeq() {
        return TCP_ACK_FIELD;
    }

    public String @NonNull [] fieldPathTcpFlags() {
        return TCP_FLAGS_FIELD;
    }

    public @NonNull String fieldOrder() {
        return ORDER;
    }

    public @NonNull Collection<@NonNull String> eventsKVMEntry() {
        return KVM_ENTRY_EVENTS;
    }

    public @NonNull Collection<@NonNull String> eventsKVMExit() {
        return KVM_EXIT_EVENTS;
    }
}

