/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlInputAttribute;

public final class CustomXmlInputElement {
    private String fElementName;
    private boolean fLogEntry;
    private CustomTraceDefinition.Tag fInputTag;
    private String fInputName;
    private int fInputAction;
    private String fInputFormat;
    private List<CustomXmlInputAttribute> fAttributes;
    private CustomXmlInputElement fParentElement;
    private CustomXmlInputElement fNextElement;
    private List<CustomXmlInputElement> fChildElements;
    private String fEventType;

    public CustomXmlInputElement() {
    }

    public CustomXmlInputElement(String elementName, boolean logEntry, CustomTraceDefinition.Tag inputTag, String inputName, int inputAction, String inputFormat, List<CustomXmlInputAttribute> attributes) {
        this.fElementName = elementName;
        this.fLogEntry = logEntry;
        this.fInputTag = inputTag;
        this.fInputName = inputName;
        this.fInputAction = inputAction;
        this.fInputFormat = inputFormat;
        this.fAttributes = attributes;
    }

    public void addAttribute(CustomXmlInputAttribute attribute) {
        if (this.getAttributes() == null) {
            this.fAttributes = new ArrayList<CustomXmlInputAttribute>(1);
        }
        this.getAttributes().add(attribute);
    }

    public void addChild(CustomXmlInputElement input) {
        if (this.getChildElements() == null) {
            this.fChildElements = new ArrayList<CustomXmlInputElement>(1);
        } else if (this.getChildElements().size() > 0) {
            CustomXmlInputElement last = this.getChildElements().get(this.getChildElements().size() - 1);
            last.fNextElement = input;
        }
        this.getChildElements().add(input);
        input.setParentElement(this);
    }

    public void addNext(CustomXmlInputElement input) {
        if (this.getParentElement() != null) {
            int index = this.getParentElement().getChildElements().indexOf(this);
            this.getParentElement().getChildElements().add(index + 1, input);
            CustomXmlInputElement next = this.getNextElement();
            this.fNextElement = input;
            input.fNextElement = next;
        }
        input.setParentElement(this.getParentElement());
    }

    public void moveUp() {
        int index;
        if (this.getParentElement() != null && (index = this.getParentElement().getChildElements().indexOf(this)) > 0) {
            this.getParentElement().getChildElements().add(index - 1, this.getParentElement().getChildElements().remove(index));
            this.getParentElement().getChildElements().get((int)index).fNextElement = this.fNextElement;
            this.fNextElement = this.getParentElement().getChildElements().get(index);
        }
    }

    public void moveDown() {
        int index;
        if (this.getParentElement() != null && (index = this.getParentElement().getChildElements().indexOf(this)) < this.getParentElement().getChildElements().size() - 1) {
            this.getParentElement().getChildElements().add(index + 1, this.getParentElement().getChildElements().remove(index));
            this.fNextElement = this.getParentElement().getChildElements().get(index).getNextElement();
            this.getParentElement().getChildElements().get((int)index).fNextElement = this;
        }
    }

    public String getElementName() {
        return this.fElementName;
    }

    public void setElementName(String elementName) {
        this.fElementName = elementName;
    }

    public boolean isLogEntry() {
        return this.fLogEntry;
    }

    public void setLogEntry(boolean logEntry) {
        this.fLogEntry = logEntry;
    }

    public CustomTraceDefinition.Tag getInputTag() {
        return this.fInputTag;
    }

    public void setInputTag(CustomTraceDefinition.Tag inputTag) {
        this.fInputTag = inputTag;
    }

    public String getInputName() {
        return this.fInputName;
    }

    public void setInputName(String inputName) {
        this.fInputName = inputName;
    }

    public String getEventType() {
        return this.fEventType;
    }

    public void setEventType(String eventType) {
        this.fEventType = eventType;
    }

    public int getInputAction() {
        return this.fInputAction;
    }

    public void setInputAction(int inputAction) {
        this.fInputAction = inputAction;
    }

    public String getInputFormat() {
        return this.fInputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.fInputFormat = inputFormat;
    }

    public List<CustomXmlInputAttribute> getAttributes() {
        return this.fAttributes;
    }

    public void setAttributes(List<CustomXmlInputAttribute> attributes) {
        this.fAttributes = attributes;
    }

    public CustomXmlInputElement getParentElement() {
        return this.fParentElement;
    }

    public void setParentElement(CustomXmlInputElement parentElement) {
        this.fParentElement = parentElement;
    }

    public CustomXmlInputElement getNextElement() {
        return this.fNextElement;
    }

    public void setNextElement(CustomXmlInputElement nextElement) {
        this.fNextElement = nextElement;
    }

    public List<CustomXmlInputElement> getChildElements() {
        return this.fChildElements;
    }

    public void setChildElements(List<CustomXmlInputElement> childElements) {
        this.fChildElements = childElements;
    }
}

