/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.validation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Annotation;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.viatra.query.patternlanguage.validation.IIssueCallback;

public class ObservableValuePatternValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.addon.databinding.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.viatra.addon.databinding.general";
    public static final String EXPRESSION_MISMATCH_ISSUE_CODE = "org.eclipse.viatra.addon.databinding.expressionmismatch";
    @Inject
    private AnnotationExpressionValidator expressionValidator;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        String value;
        if (annotation.getParameters().isEmpty()) {
            return;
        }
        Pattern pattern = (Pattern)annotation.eContainer();
        ValueReference ref = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"expression");
        ValueReference labelRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"labelExpression");
        if (ref == null && labelRef == null) {
            validator.error("Specify either the parameter 'expression' or 'labelExpression'", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__PARAMETERS, EXPRESSION_MISMATCH_ISSUE_CODE, new String[0]);
        }
        if (ref != null && labelRef != null) {
            validator.error("Specify only one of the parameter 'expression' or 'labelExpression'", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__PARAMETERS, EXPRESSION_MISMATCH_ISSUE_CODE, new String[0]);
        }
        if (ref instanceof StringValue) {
            value = ((StringValue)ref).getValue();
            if (value.contains("$")) {
                validator.warning("The expressions are not required to be escaped using $ characters.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
            }
            this.expressionValidator.validateModelExpression(value, pattern, ref, validator);
        }
        if (labelRef instanceof StringValue) {
            value = ((StringValue)labelRef).getValue();
            if (!value.contains("$")) {
                validator.warning("The label expressions should contain escaped references using $ characters.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
            }
            this.expressionValidator.validateStringExpression(value, pattern, labelRef, validator);
        }
    }
}

