/**
 * Copyright (c) 2010-2015, Abel Hegedus, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.addon.querybasedfeatures.tooling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.addon.querybasedfeatures.tooling.QueryBasedFeatureParameters;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Annotation;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Type;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.viatra.query.runtime.extensibility.PQueryExtensionFactory;
import org.eclipse.viatra.query.runtime.extensibility.ViatraQueryRuntimeConstants;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionData;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionGenerator;
import org.eclipse.viatra.query.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.viatra.query.tooling.core.generator.genmodel.IVQGenmodelProvider;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.w3c.dom.Element;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class SurrogateGeneratorFragment implements IGenerationFragment {
  @Inject
  protected IVQGenmodelProvider provider;
  
  @Inject
  protected Logger logger;
  
  @Inject
  protected IErrorFeedback errorFeedback;
  
  @Inject
  @Extension
  protected ExtensionGenerator exGen;
  
  @Inject
  @Extension
  protected EMFPatternLanguageJvmModelInferrerUtil inferrerUtil;
  
  protected static String SURROGATE_ERROR_CODE = "org.eclipse.viatra.query.runtime.surrogatequeryemf.error";
  
  protected static String SURROGATE_EXTENSION_PREFIX = "extension.surrogate.";
  
  @Override
  public Collection<Pair<String, String>> getRemovableExtensions() {
    Pair<String, String> _of = Pair.<String, String>of(SurrogateGeneratorFragment.SURROGATE_EXTENSION_PREFIX, ViatraQueryRuntimeConstants.SURROGATE_QUERY_EXTENSIONID);
    return CollectionLiterals.<Pair<String, String>>newArrayList(_of);
  }
  
  @Override
  public Iterable<Pair<String, String>> removeExtension(final Pattern pattern) {
    String _derivedContributionId = this.derivedContributionId(pattern);
    Pair<String, String> _of = Pair.<String, String>of(_derivedContributionId, ViatraQueryRuntimeConstants.SURROGATE_QUERY_EXTENSIONID);
    return CollectionLiterals.<Pair<String, String>>newArrayList(_of);
  }
  
  @Override
  public Iterable<ExtensionData> extensionContribution(final Pattern pattern) {
    String _derivedContributionId = this.derivedContributionId(pattern);
    final Procedure1<Element> _function = new Procedure1<Element>() {
      @Override
      public void apply(final Element it) {
        ArrayList<QueryBasedFeatureParameters> _gatherSurrogateParameters = SurrogateGeneratorFragment.this.gatherSurrogateParameters(pattern);
        final Procedure1<QueryBasedFeatureParameters> _function = new Procedure1<QueryBasedFeatureParameters>() {
          @Override
          public void apply(final QueryBasedFeatureParameters parameters) {
            final Procedure1<Element> _function = new Procedure1<Element>() {
              @Override
              public void apply(final Element it) {
                String _nsURI = parameters.ePackage.getNsURI();
                SurrogateGeneratorFragment.this.exGen.contribAttribute(it, "package-nsUri", _nsURI);
                String _name = parameters.source.getName();
                SurrogateGeneratorFragment.this.exGen.contribAttribute(it, "class-name", _name);
                String _name_1 = parameters.feature.getName();
                SurrogateGeneratorFragment.this.exGen.contribAttribute(it, "feature-name", _name_1);
                String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
                SurrogateGeneratorFragment.this.exGen.contribAttribute(it, "query-fqn", _fullyQualifiedName);
                String _canonicalName = PQueryExtensionFactory.class.getCanonicalName();
                String _plus = (_canonicalName + ":");
                String _utilPackageName = SurrogateGeneratorFragment.this.inferrerUtil.getUtilPackageName(pattern);
                String _plus_1 = (_plus + _utilPackageName);
                String _plus_2 = (_plus_1 + ".");
                String _querySpecificationClassName = SurrogateGeneratorFragment.this.inferrerUtil.querySpecificationClassName(pattern);
                String _plus_3 = (_plus_2 + _querySpecificationClassName);
                SurrogateGeneratorFragment.this.exGen.contribAttribute(it, "surrogate-query", _plus_3);
              }
            };
            SurrogateGeneratorFragment.this.exGen.contribElement(it, "surrogate-query-emf", _function);
          }
        };
        IterableExtensions.<QueryBasedFeatureParameters>forEach(_gatherSurrogateParameters, _function);
      }
    };
    ExtensionData _contribExtension = this.exGen.contribExtension(_derivedContributionId, ViatraQueryRuntimeConstants.SURROGATE_QUERY_EXTENSIONID, _function);
    final ArrayList<ExtensionData> surrogateExtension = CollectionLiterals.<ExtensionData>newArrayList(_contribExtension);
    return surrogateExtension;
  }
  
  protected ArrayList<QueryBasedFeatureParameters> gatherSurrogateParameters(final Pattern pattern) {
    final ArrayList<QueryBasedFeatureParameters> parameterList = CollectionLiterals.<QueryBasedFeatureParameters>newArrayList();
    Collection<Annotation> _annotationsByName = CorePatternLanguageHelper.getAnnotationsByName(pattern, "Surrogate");
    for (final Annotation annotation : _annotationsByName) {
      try {
        QueryBasedFeatureParameters _processAnnotation = this.processAnnotation(pattern, annotation, false);
        parameterList.add(_processAnnotation);
      } catch (final Throwable _t) {
        if (_t instanceof IllegalArgumentException) {
          final IllegalArgumentException e = (IllegalArgumentException)_t;
          String _message = e.getMessage();
          this.logger.error(_message);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    boolean _isEmpty = parameterList.isEmpty();
    if (_isEmpty) {
      return CollectionLiterals.<QueryBasedFeatureParameters>newArrayList();
    }
    return parameterList;
  }
  
  protected String derivedContributionId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    return (SurrogateGeneratorFragment.SURROGATE_EXTENSION_PREFIX + _fullyQualifiedName);
  }
  
  @Override
  public void generateFiles(final Pattern pattern, final IFileSystemAccess fsa) {
    ArrayList<QueryBasedFeatureParameters> _gatherSurrogateParameters = this.gatherSurrogateParameters(pattern);
    final Procedure1<QueryBasedFeatureParameters> _function = new Procedure1<QueryBasedFeatureParameters>() {
      @Override
      public void apply(final QueryBasedFeatureParameters parameters) {
      }
    };
    IterableExtensions.<QueryBasedFeatureParameters>forEach(_gatherSurrogateParameters, _function);
  }
  
  @Override
  public void cleanUp(final Pattern pattern, final IFileSystemAccess fsa) {
    ArrayList<QueryBasedFeatureParameters> _gatherSurrogateParameters = this.gatherSurrogateParameters(pattern);
    final Procedure1<QueryBasedFeatureParameters> _function = new Procedure1<QueryBasedFeatureParameters>() {
      @Override
      public void apply(final QueryBasedFeatureParameters parameters) {
      }
    };
    IterableExtensions.<QueryBasedFeatureParameters>forEach(_gatherSurrogateParameters, _function);
  }
  
  @Override
  public IPath[] getAdditionalBinIncludes() {
    return ((IPath[])Conversions.unwrapArray(CollectionLiterals.<IPath>newArrayList(), IPath.class));
  }
  
  @Override
  public String[] getProjectDependencies() {
    return ((String[])Conversions.unwrapArray(CollectionLiterals.<String>newArrayList(), String.class));
  }
  
  @Override
  public String getProjectPostfix() {
    return null;
  }
  
  protected QueryBasedFeatureParameters processAnnotation(final Pattern pattern, final Annotation annotation, final boolean feedback) {
    final QueryBasedFeatureParameters parameters = new QueryBasedFeatureParameters();
    parameters.pattern = pattern;
    parameters.annotation = annotation;
    String featureTmp = "";
    EList<Variable> _parameters = pattern.getParameters();
    int _size = _parameters.size();
    boolean _notEquals = (_size != 2);
    if (_notEquals) {
      if (feedback) {
        this.errorFeedback.reportError(pattern, "Pattern must have exactly 2 parameters!", SurrogateGeneratorFragment.SURROGATE_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
      }
      String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus = ("Surrogate pattern " + _fullyQualifiedName);
      String _plus_1 = (_plus + " must have 2 parameters!");
      throw new IllegalArgumentException(_plus_1);
    }
    EList<AnnotationParameter> _parameters_1 = annotation.getParameters();
    for (final AnnotationParameter ap : _parameters_1) {
      String _name = ap.getName();
      boolean _matches = _name.matches("feature");
      if (_matches) {
        ValueReference _value = ap.getValue();
        String _value_1 = ((StringValue) _value).getValue();
        featureTmp = _value_1;
      }
    }
    boolean _equals = Objects.equal(featureTmp, "");
    if (_equals) {
      String _name_1 = pattern.getName();
      featureTmp = _name_1;
    }
    EList<Variable> _parameters_2 = pattern.getParameters();
    final Variable sourcevar = _parameters_2.get(0);
    final Type sourceType = sourcevar.getType();
    boolean _or = false;
    boolean _not = (!(sourceType instanceof ClassType));
    if (_not) {
      _or = true;
    } else {
      EClassifier _classname = ((ClassType) sourceType).getClassname();
      boolean _not_1 = (!(_classname instanceof EClass));
      _or = _not_1;
    }
    if (_or) {
      if (feedback) {
        String _name_2 = sourcevar.getName();
        String _plus_2 = ("Source " + _name_2);
        String _plus_3 = (_plus_2 + " is not EClass!");
        this.errorFeedback.reportError(sourcevar, _plus_3, SurrogateGeneratorFragment.SURROGATE_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
      }
      String _fullyQualifiedName_1 = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus_4 = ("Surrogate pattern " + _fullyQualifiedName_1);
      String _plus_5 = (_plus_4 + ": Source ");
      String _name_3 = sourcevar.getName();
      String _plus_6 = (_plus_5 + _name_3);
      String _plus_7 = (_plus_6 + " is not EClass!");
      throw new IllegalArgumentException(_plus_7);
    }
    EClassifier _classname_1 = ((ClassType) sourceType).getClassname();
    EClass source = ((EClass) _classname_1);
    parameters.source = source;
    boolean _or_1 = false;
    boolean _equals_1 = Objects.equal(source, null);
    if (_equals_1) {
      _or_1 = true;
    } else {
      EPackage _ePackage = source.getEPackage();
      boolean _equals_2 = Objects.equal(_ePackage, null);
      _or_1 = _equals_2;
    }
    if (_or_1) {
      if (feedback) {
        this.errorFeedback.reportError(sourcevar, "Source EClass or EPackage not found!", SurrogateGeneratorFragment.SURROGATE_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
      }
      String _fullyQualifiedName_2 = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus_8 = ("Surrogate pattern " + _fullyQualifiedName_2);
      String _plus_9 = (_plus_8 + ": Source EClass or EPackage not found!");
      throw new IllegalArgumentException(_plus_9);
    }
    final EPackage pckg = source.getEPackage();
    boolean _equals_3 = Objects.equal(pckg, null);
    if (_equals_3) {
      if (feedback) {
        this.errorFeedback.reportError(sourcevar, "EPackage not found!", SurrogateGeneratorFragment.SURROGATE_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
      }
      String _fullyQualifiedName_3 = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus_10 = ("Surrogate pattern " + _fullyQualifiedName_3);
      String _plus_11 = (_plus_10 + ": EPackage not found!");
      throw new IllegalArgumentException(_plus_11);
    }
    parameters.ePackage = pckg;
    final String featureString = featureTmp;
    EList<EStructuralFeature> _eAllStructuralFeatures = source.getEAllStructuralFeatures();
    final Function1<EStructuralFeature, Boolean> _function = new Function1<EStructuralFeature, Boolean>() {
      @Override
      public Boolean apply(final EStructuralFeature it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, featureString));
      }
    };
    final Iterable<EStructuralFeature> features = IterableExtensions.<EStructuralFeature>filter(_eAllStructuralFeatures, _function);
    int _size_1 = IterableExtensions.size(features);
    boolean _notEquals_1 = (_size_1 != 1);
    if (_notEquals_1) {
      if (feedback) {
        String _name_4 = source.getName();
        String _plus_12 = ((("Feature " + featureTmp) + " not found in class ") + _name_4);
        String _plus_13 = (_plus_12 + "!");
        this.errorFeedback.reportError(annotation, _plus_13, SurrogateGeneratorFragment.SURROGATE_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
      }
      String _fullyQualifiedName_4 = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus_14 = ("Surrogate pattern " + _fullyQualifiedName_4);
      String _plus_15 = (_plus_14 + ": Feature ");
      String _plus_16 = (_plus_15 + featureTmp);
      String _plus_17 = (_plus_16 + " not found in class ");
      String _name_5 = source.getName();
      String _plus_18 = (_plus_17 + _name_5);
      String _plus_19 = (_plus_18 + "!");
      throw new IllegalArgumentException(_plus_19);
    }
    Iterator<EStructuralFeature> _iterator = features.iterator();
    final EStructuralFeature feature = _iterator.next();
    parameters.feature = feature;
    EList<Variable> _parameters_3 = pattern.getParameters();
    Variable _get = _parameters_3.get(1);
    String _name_6 = _get.getName();
    parameters.targetVar = _name_6;
    return parameters;
  }
}
