/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.viatra.query.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.DefaultMailbox;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MonotonicityAwareMailbox;
import org.eclipse.viatra.query.runtime.rete.network.MonotonicityAwareReceiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.Tunnel;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;
import org.eclipse.viatra.query.runtime.rete.tuple.TupleMemory;

public class UniquenessEnforcerNode
extends StandardNode
implements Tunnel,
RederivableNode,
MonotonicityAwareReceiver {
    protected Collection<Supplier> parents = new ArrayList<Supplier>();
    protected TupleMemory memory;
    protected TupleMemory rederivableMemory;
    protected boolean deleteRederiveEvaluation;
    protected MemoryNullIndexer memoryNullIndexer;
    protected MemoryIdentityIndexer memoryIdentityIndexer;
    protected final int tupleWidth;
    protected final Mailbox mailbox;
    private final TupleMask nullMask;
    private final TupleMask identityMask;
    protected final List<SpecializedProjectionIndexer.ListenerSubscription> specializedListeners = new ArrayList<SpecializedProjectionIndexer.ListenerSubscription>();
    protected final TupleMask coreMask;
    protected final TupleMask posetMask;
    protected final IPosetComparator posetComparator;

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth) {
        this(reteContainer, tupleWidth, false);
    }

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth, boolean deleteRederiveEvaluation) {
        this(reteContainer, tupleWidth, deleteRederiveEvaluation, null, null, null);
    }

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth, boolean deleteRederiveEvaluation, TupleMask coreMask, TupleMask posetMask, IPosetComparator posetComparator) {
        super(reteContainer);
        this.memory = new TupleMemory();
        this.rederivableMemory = new TupleMemory();
        this.tupleWidth = tupleWidth;
        reteContainer.registerClearable(this.memory);
        reteContainer.registerClearable(this.rederivableMemory);
        this.nullMask = TupleMask.linear((int)0, (int)tupleWidth);
        this.identityMask = TupleMask.identity((int)tupleWidth);
        this.deleteRederiveEvaluation = deleteRederiveEvaluation;
        this.coreMask = coreMask;
        this.posetMask = posetMask;
        this.posetComparator = posetComparator;
        this.mailbox = this.instantiateMailbox();
        reteContainer.registerClearable(this.mailbox);
    }

    @Override
    public TupleMask getCoreMask() {
        return this.coreMask;
    }

    @Override
    public TupleMask getPosetMask() {
        return this.posetMask;
    }

    @Override
    public IPosetComparator getPosetComparator() {
        return this.posetComparator;
    }

    protected Mailbox instantiateMailbox() {
        if (this.coreMask != null && this.posetMask != null && this.posetComparator != null) {
            return new MonotonicityAwareMailbox(this, this.reteContainer);
        }
        return new DefaultMailbox(this, this.reteContainer);
    }

    public TupleMemory getMemory() {
        return this.memory;
    }

    @Override
    public Mailbox getMailbox() {
        return this.mailbox;
    }

    @Override
    public void update(Direction direction, Tuple update) {
        this.update(direction, update, false);
    }

    @Override
    public void update(Direction direction, Tuple update, boolean monotone) {
        if (this.deleteRederiveEvaluation) {
            if (this.updateWithDeleteAndRederive(direction, update, monotone)) {
                this.propagate(direction, update);
            }
        } else if (this.updateDefault(direction, update)) {
            this.propagate(direction, update);
        }
    }

    protected boolean updateWithDeleteAndRederive(Direction direction, Tuple update, boolean monotone) {
        boolean propagate = false;
        int memoryCount = this.memory.get(update);
        int rederivableCount = this.rederivableMemory.get(update);
        if (direction == Direction.INSERT) {
            if (rederivableCount != 0) {
                this.rederivableMemory.add(update);
                if (this.rederivableMemory.isEmpty()) {
                    this.reteContainer.getTracker().removeRederivable(this);
                }
            } else {
                propagate = this.memory.add(update);
            }
        } else if (rederivableCount != 0) {
            if (memoryCount != 0) {
                this.issueError("[INTERNAL ERROR] Inconsistent state for " + update + " because it is present both in the main and re-derivable memory in the UniquenessEnforcerNode " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), null);
            }
            try {
                this.rederivableMemory.remove(update);
            }
            catch (NullPointerException ex) {
                this.issueError("[INTERNAL ERROR] Duplicate deletion of " + update + " was detected in UniquenessEnforcer " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), ex);
            }
            if (this.rederivableMemory.isEmpty()) {
                this.reteContainer.getTracker().removeRederivable(this);
            }
        } else if (monotone) {
            propagate = this.memory.remove(update);
        } else {
            int count = memoryCount - 1;
            if (count > 0) {
                if (this.rederivableMemory.isEmpty()) {
                    this.reteContainer.getTracker().addRederivable(this);
                }
                this.rederivableMemory.add(update, count);
            }
            this.memory.clear(update);
            propagate = true;
        }
        return propagate;
    }

    protected boolean updateDefault(Direction direction, Tuple update) {
        boolean propagate = false;
        if (direction == Direction.INSERT) {
            propagate = this.memory.add(update);
        } else {
            try {
                propagate = this.memory.remove(update);
            }
            catch (NullPointerException ex) {
                propagate = false;
                this.issueError("[INTERNAL ERROR] Duplicate deletion of " + update + " was detected in UniquenessEnforcer " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), ex);
            }
        }
        return propagate;
    }

    @Override
    public void rederiveOne() {
        Tuple update = this.rederivableMemory.iterator().next();
        int count = this.rederivableMemory.get(update);
        this.rederivableMemory.clear(update);
        this.memory.add(update, count);
        if (this.rederivableMemory.isEmpty()) {
            this.reteContainer.getTracker().removeRederivable(this);
        }
        this.propagate(Direction.INSERT, update);
    }

    protected void propagate(Direction direction, Tuple update) {
        for (SpecializedProjectionIndexer.ListenerSubscription subscription : this.specializedListeners) {
            subscription.propagate(direction, update);
        }
        this.propagateUpdate(direction, update);
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        if (this.nullMask.equals((Object)mask)) {
            MemoryNullIndexer indexer = this.getNullIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                indexer.assignTraceInfo(traceInfo);
                ++n2;
            }
            return indexer;
        }
        if (this.identityMask.equals((Object)mask)) {
            MemoryIdentityIndexer indexer = this.getIdentityIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n3 = 0;
            while (n3 < n) {
                TraceInfo traceInfo = traceInfoArray[n3];
                indexer.assignTraceInfo(traceInfo);
                ++n3;
            }
            return indexer;
        }
        return super.constructIndex(mask, traces);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        collector.addAll(this.memory);
    }

    public MemoryNullIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new MemoryNullIndexer(this.reteContainer, this.tupleWidth, this.memory, this, this, this.specializedListeners);
            this.reteContainer.getTracker().registerDependency(this, this.memoryNullIndexer);
        }
        return this.memoryNullIndexer;
    }

    public MemoryIdentityIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new MemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.memory, this, this, this.specializedListeners);
            this.reteContainer.getTracker().registerDependency(this, this.memoryIdentityIndexer);
        }
        return this.memoryIdentityIndexer;
    }

    @Override
    public void appendParent(Supplier supplier) {
        this.parents.add(supplier);
    }

    @Override
    public void removeParent(Supplier supplier) {
        this.parents.remove(supplier);
    }

    @Override
    public Collection<Supplier> getParents() {
        return this.parents;
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromStandardNodeToSupplierParent()) {
            for (Supplier parent : this.parents) {
                parent.acceptPropagatedTraceInfo(traceInfo);
            }
        }
    }
}

