/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.palette;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.controls.palette.DefaultPalettePreferences;
import org.eclipse.wb.core.controls.palette.HtmlPaletteTooltipProvider;
import org.eclipse.wb.core.controls.palette.ICategory;
import org.eclipse.wb.core.controls.palette.IEntry;
import org.eclipse.wb.core.controls.palette.IPalette;
import org.eclipse.wb.core.controls.palette.IPalettePreferences;
import org.eclipse.wb.core.controls.palette.SimplePaletteTooltipProvider;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.events.IMouseListener;
import org.eclipse.wb.draw2d.events.IMouseMoveListener;
import org.eclipse.wb.draw2d.events.IMouseTrackListener;
import org.eclipse.wb.draw2d.events.MouseEvent;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.TargetFigureFindVisitor;

public final class PaletteComposite
extends Composite {
    private static final Color COLOR_PALETTE_BACKGROUND = IColorConstants.button;
    private static final Color COLOR_TEXT_ENABLED = IColorConstants.listForeground;
    private static final Color COLOR_TEXT_DISABLED = IColorConstants.gray;
    private static final Color COLOR_ENTRY_SELECTED = DrawUtils.getShiftedColor(COLOR_PALETTE_BACKGROUND, 24);
    private static final Color COLOR_CATEGORY_GRAD_BEGIN = DrawUtils.getShiftedColor(COLOR_PALETTE_BACKGROUND, -8);
    private static final Color COLOR_CATEGORY_GRAD_END = DrawUtils.getShiftedColor(COLOR_PALETTE_BACKGROUND, 16);
    private static final Color COLOR_CATEGORY_SEL_GRAD_BEGIN = DrawUtils.getShiftedColor(COLOR_PALETTE_BACKGROUND, 16);
    private static final Color COLOR_CATEGORY_SEL_GRAD_END = DrawUtils.getShiftedColor(COLOR_CATEGORY_GRAD_BEGIN, -8);
    private static final Image NO_ICON = PaletteComposite.loadImage("icons/no_icon.gif");
    private static final Image FOLDER_OPEN = PaletteComposite.loadImage("icons/folder_open.gif");
    private static final Image FOLDER_CLOSED = PaletteComposite.loadImage("icons/folder_closed.gif");
    private IPalettePreferences m_preferences;
    private final FigureCanvas m_figureCanvas;
    private final GC m_paletteGC;
    private final PaletteFigure m_paletteFigure;
    private final Layer m_feedbackLayer;
    private final Map<ICategory, CategoryFigure> m_categoryFigures = Maps.newHashMap();
    private MenuManager m_menuManager;
    private IPalette m_palette;
    private IEntry m_selectedEntry;
    private Object m_forcedTargetObject;

    private static Image loadImage(String path) {
        return DrawUtils.loadImage(PaletteComposite.class, path);
    }

    public PaletteComposite(Composite parent, int style) {
        super(parent, style);
        this.m_preferences = new DefaultPalettePreferences();
        this.setLayout((Layout)new FillLayout());
        this.m_figureCanvas = new FigureCanvas(this, 512);
        this.m_figureCanvas.getRootFigure().setBackground(COLOR_PALETTE_BACKGROUND);
        this.m_figureCanvas.getRootFigure().setForeground(COLOR_TEXT_ENABLED);
        this.m_paletteGC = new GC((Drawable)this.m_figureCanvas);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                PaletteComposite.this.m_paletteGC.dispose();
            }
        });
        this.m_paletteFigure = new PaletteFigure();
        this.m_figureCanvas.getRootFigure().add(this.m_paletteFigure);
        this.m_menuManager = new MenuManager();
        this.m_menuManager.setRemoveAllWhenShown(true);
        this.m_figureCanvas.setMenu(this.m_menuManager.createContextMenu((Control)this.m_figureCanvas));
        this.m_menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PaletteComposite.this.addPopupActions(manager);
            }
        });
        this.m_feedbackLayer = new Layer("feedback");
        this.m_figureCanvas.getRootFigure().add(this.m_feedbackLayer);
    }

    private void addPopupActions(IMenuManager menuManager) {
        org.eclipse.swt.graphics.Point cursorLocation = this.getDisplay().getCursorLocation();
        cursorLocation = this.m_figureCanvas.toControl(cursorLocation);
        TargetFigureFindVisitor visitor = new TargetFigureFindVisitor(this.m_figureCanvas, cursorLocation.x, cursorLocation.y);
        this.m_figureCanvas.getRootFigure().accept(visitor, false);
        Figure targetFigure = visitor.getTargetFigure();
        Object targetObject = null;
        if (targetFigure instanceof CategoryFigure) {
            targetObject = ((CategoryFigure)targetFigure).m_category;
        } else if (targetFigure instanceof EntryFigure) {
            targetObject = ((EntryFigure)targetFigure).m_entry;
        }
        if (this.m_forcedTargetObject != null) {
            targetObject = this.m_forcedTargetObject;
        }
        this.m_palette.addPopupActions(menuManager, targetObject);
    }

    public void setPalette(IPalette palette) {
        this.m_palette = palette;
        this.refreshPalette();
    }

    public void refreshPalette() {
        this.m_paletteFigure.refresh();
    }

    public void setPreferences(IPalettePreferences preferences) {
        this.m_preferences = preferences;
        this.m_paletteFigure.onPreferencesUpdate();
    }

    public void selectEntry(IEntry selectedEntry, boolean reload) {
        boolean activated;
        this.m_selectedEntry = selectedEntry;
        if (this.m_selectedEntry != null && !(activated = this.m_selectedEntry.activate(reload))) {
            this.m_palette.selectDefault();
        }
        this.m_paletteFigure.repaint();
    }

    public Figure getCategoryFigure(ICategory category) {
        return this.m_categoryFigures.get(category);
    }

    public Figure getEntryFigure(ICategory category, IEntry entry) {
        CategoryFigure categoryFigure = this.m_categoryFigures.get(category);
        return (Figure)categoryFigure.m_entryFigures.get(entry);
    }

    public void layoutPalette() {
        this.m_paletteFigure.layout();
    }

    private Figure getTargetFigure(Figure source, Point p) {
        Point absoluteLocation = p.getCopy();
        FigureUtils.translateFigureToCanvas(source, absoluteLocation);
        TargetFigureFindVisitor visitor = new TargetFigureFindVisitor(this.m_figureCanvas, absoluteLocation.x, absoluteLocation.y);
        this.m_figureCanvas.getRootFigure().accept(visitor, false);
        return visitor.getTargetFigure();
    }

    private static void setToolTip(Figure figure, String header, String details) {
        if (header != null && details != null) {
            figure.setCustomTooltipProvider(new HtmlPaletteTooltipProvider(header, details));
        } else if (details == null) {
            figure.setCustomTooltipProvider(new SimplePaletteTooltipProvider(header));
        } else if (header == null) {
            figure.setCustomTooltipProvider(new HtmlPaletteTooltipProvider(null, details));
        }
    }

    public static final void drawStringCV(Graphics graphics, String text, Rectangle r) {
        PaletteComposite.drawStringCV(graphics, text, r.x, r.y, r.width, r.height);
    }

    public static final void drawStringCV(Graphics graphics, String text, int x, int y, int width, int height) {
        int textY = y + (height - graphics.getFontMetrics().getHeight()) / 2;
        String clipString = DrawUtils.clipString(graphics.gc, text, width);
        graphics.drawText(clipString, x, textY);
    }

    public static final void drawImageCV(Graphics graphics, Image image, int x, int y, int height) {
        if (image != null) {
            int imageHeight = image.getBounds().height;
            graphics.drawImage(image, x, y + (height - imageHeight) / 2);
        }
    }

    private static void drawRectangle3D(Graphics gc, Rectangle r, boolean up) {
        int x = r.x;
        int y = r.y;
        int right = r.right() - 1;
        int bottom = r.bottom() - 1;
        if (up) {
            gc.setForegroundColor(IColorConstants.buttonLightest);
        } else {
            gc.setForegroundColor(IColorConstants.buttonDarker);
        }
        gc.drawLine(x, y, right, y);
        gc.drawLine(x, y, x, bottom);
        if (up) {
            gc.setForegroundColor(IColorConstants.buttonDarker);
        } else {
            gc.setForegroundColor(IColorConstants.buttonLightest);
        }
        gc.drawLine(right, y, right, bottom);
        gc.drawLine(x, bottom, right, bottom);
    }

    private final class CategoryFigure
    extends Figure {
        private static final int IMAGE_SPACE_LEFT = 4;
        private static final int IMAGE_SPACE_RIGHT = 4;
        private static final int MARGIN_HEIGHT = 2;
        private final ICategory m_category;
        private final Map<IEntry, EntryFigure> m_entryFigures = Maps.newHashMap();
        private int m_columns;
        private int m_titleHeight;
        private boolean m_mouseOnTitle;
        private boolean m_mouseDown;
        private Point m_downPoint;
        private boolean m_moving;
        private Figure m_feedback;
        private Command m_moveCommand;

        public CategoryFigure(ICategory category) {
            this.m_category = category;
            this.hookEvents();
            PaletteComposite.setToolTip(this, null, this.m_category.getToolTipText());
            this.onPreferencesUpdate();
            Iterator<IEntry> iterator = this.m_category.getEntries().iterator();
            while (iterator.hasNext()) {
                IEntry element;
                IEntry entry = element = iterator.next();
                EntryFigure entryFigure = new EntryFigure(entry);
                this.m_entryFigures.put(entry, entryFigure);
                this.add(entryFigure);
            }
        }

        public void onPreferencesUpdate() {
            this.setFont(PaletteComposite.this.m_preferences.getCategoryFont());
            for (EntryFigure entryFigure : this.getChildren()) {
                entryFigure.onPreferencesUpdate();
            }
        }

        private void hookEvents() {
            this.addMouseListener(new IMouseListener(){

                public void mouseDoubleClick(MouseEvent event) {
                }

                public void mouseDown(MouseEvent event) {
                    if (event.button == 1 && CategoryFigure.this.m_mouseOnTitle) {
                        CategoryFigure.this.m_mouseDown = true;
                        CategoryFigure.this.setCapture(true);
                        CategoryFigure.this.m_downPoint = new Point(event.x, event.y);
                    }
                }

                public void mouseUp(MouseEvent event) {
                    if (event.button == 1) {
                        CategoryFigure.this.m_mouseDown = false;
                        CategoryFigure.this.setCapture(false);
                        if (CategoryFigure.this.m_moving) {
                            CategoryFigure.this.m_moving = false;
                            CategoryFigure.this.move_eraseFeedback();
                            if (CategoryFigure.this.m_moveCommand != null) {
                                try {
                                    CategoryFigure.this.m_moveCommand.execute();
                                }
                                catch (Throwable throwable) {}
                            }
                        } else if (CategoryFigure.this.m_mouseOnTitle) {
                            CategoryFigure.this.m_category.setOpen(!CategoryFigure.this.m_category.isOpen());
                            PaletteComposite.this.m_paletteFigure.layout();
                        }
                    }
                    CategoryFigure.this.repaint();
                }
            });
            this.addMouseMoveListener(new IMouseMoveListener(){

                public void mouseMove(MouseEvent event) {
                    if (CategoryFigure.this.m_mouseDown) {
                        Point p = new Point(event.x, event.y);
                        if (!CategoryFigure.this.m_moving && CategoryFigure.this.m_downPoint.getDistance(p) > 4.0) {
                            CategoryFigure.this.m_moving = true;
                        }
                        if (CategoryFigure.this.m_moving) {
                            CategoryFigure.this.move_showFeedback(p);
                        }
                    } else {
                        CategoryFigure.this.m_mouseOnTitle = CategoryFigure.this.getTitleRectangle().contains(event.x, event.y);
                        CategoryFigure.this.repaint();
                    }
                }
            });
            this.addMouseTrackListener(new IMouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    CategoryFigure.this.m_mouseOnTitle = false;
                    CategoryFigure.this.repaint();
                }

                public void mouseHover(MouseEvent e) {
                }
            });
        }

        private void move_showFeedback(Point p) {
            this.move_eraseFeedback();
            this.m_moveCommand = null;
            Figure targetFigure = PaletteComposite.this.getTargetFigure(this, p);
            if (targetFigure instanceof EntryFigure) {
                targetFigure = targetFigure.getParent();
            }
            if (targetFigure instanceof CategoryFigure) {
                Point feedbackLocation;
                boolean before;
                final ICategory category_1 = ((CategoryFigure)targetFigure).m_category;
                List<Figure> siblings = targetFigure.getParent().getChildren();
                Figure nextFigure = GenericsUtils.getNextOrNull(siblings, targetFigure);
                final ICategory category_2 = nextFigure != null ? ((CategoryFigure)nextFigure).m_category : null;
                Point targetLocation = p.getCopy();
                FigureUtils.translateFigureToFigure2(this, targetFigure, targetLocation);
                if (targetLocation.y > targetFigure.getSize().height / 2) {
                    before = true;
                    feedbackLocation = targetFigure.getBounds().getBottomLeft();
                } else {
                    before = false;
                    feedbackLocation = targetFigure.getBounds().getTopLeft();
                }
                FigureUtils.translateFigureToAbsolute(targetFigure, feedbackLocation);
                this.m_feedback = new FeedbackLine(PaletteComposite.this.m_feedbackLayer, true, feedbackLocation, targetFigure.getSize().width);
                this.m_moveCommand = new Command(){

                    public void execute() throws Exception {
                        ICategory targetCategory;
                        ICategory iCategory = targetCategory = before ? category_2 : category_1;
                        if (category_1 != CategoryFigure.this.m_category) {
                            PaletteComposite.this.m_palette.moveCategory(CategoryFigure.this.m_category, targetCategory);
                        }
                    }
                };
            }
        }

        private void move_eraseFeedback() {
            if (this.m_feedback != null) {
                this.m_feedback.getParent().remove(this.m_feedback);
                this.m_feedback = null;
            }
        }

        public int layout(int y, int width) {
            int height = this.m_titleHeight = 2 + ((PaletteComposite)PaletteComposite.this).m_paletteGC.textExtent((String)this.m_category.getText()).y + 2;
            if (this.m_category.isOpen() && !this.getChildren().isEmpty()) {
                int maxWidth = 0;
                int maxHeight = 0;
                boolean onlyIcons = PaletteComposite.this.m_preferences.isOnlyIcons();
                for (Figure child : this.getChildren()) {
                    EntryFigure entryFigure = (EntryFigure)child;
                    Dimension entrySize = onlyIcons ? entryFigure.getIconSize() : entryFigure.getIconTextSize();
                    maxWidth = Math.max(maxWidth, entrySize.width);
                    maxHeight = Math.max(maxHeight, entrySize.height);
                }
                this.m_columns = width / maxWidth;
                if (!onlyIcons) {
                    this.m_columns = Math.max(this.m_columns, PaletteComposite.this.m_preferences.getMinColumns());
                }
                this.m_columns = Math.min(this.m_columns, this.getChildren().size());
                this.m_columns = Math.max(this.m_columns, 1);
                int column = 0;
                int entryY = height;
                for (Figure child : this.getChildren()) {
                    EntryFigure entryFigure = (EntryFigure)child;
                    if (onlyIcons) {
                        int x = maxWidth * column;
                        entryFigure.setBounds(new Rectangle(x, entryY, maxWidth, maxHeight));
                    } else {
                        int columnWidth = width / this.m_columns;
                        int x = columnWidth * column;
                        entryFigure.setBounds(new Rectangle(x, entryY, columnWidth, maxHeight));
                    }
                    if (column == 0) {
                        height += maxHeight;
                    }
                    if (++column != this.m_columns) continue;
                    column = 0;
                    entryY += maxHeight;
                }
            }
            this.setBounds(new Rectangle(0, y, width, height));
            return height;
        }

        protected void paintClientArea(Graphics graphics) {
            Rectangle r = this.getClientArea();
            r.height = this.m_titleHeight;
            graphics.pushState();
            if (this.m_mouseOnTitle || this.m_moving) {
                graphics.setForegroundColor(COLOR_CATEGORY_SEL_GRAD_BEGIN);
                graphics.setBackgroundColor(COLOR_CATEGORY_SEL_GRAD_END);
            } else {
                graphics.setForegroundColor(COLOR_CATEGORY_GRAD_BEGIN);
                graphics.setBackgroundColor(COLOR_CATEGORY_GRAD_END);
            }
            graphics.fillGradient(r, true);
            PaletteComposite.drawRectangle3D(graphics, r, true);
            graphics.popState();
            Image stateImage = this.m_category.isOpen() ? FOLDER_OPEN : FOLDER_CLOSED;
            r.moveX(4);
            PaletteComposite.drawImageCV(graphics, stateImage, r.x, r.y, r.height);
            int imageWidth = stateImage.getBounds().width;
            r.moveX(imageWidth + 4);
            PaletteComposite.drawStringCV(graphics, this.m_category.getText(), r);
        }

        private Rectangle getTitleRectangle() {
            Rectangle r = this.getClientArea().getCopy();
            r.height = this.m_titleHeight;
            return r;
        }
    }

    private final class EntryFigure
    extends Figure {
        private static final int IMAGE_SPACE_RIGHT = 2;
        private static final int MARGIN_WIDTH_1 = 3;
        private static final int MARGIN_WIDTH_2 = 6;
        private static final int MARGIN_HEIGHT = 3;
        private final IEntry m_entry;
        private boolean m_mouseInside;
        private boolean m_mouseDown;
        private Point m_downPoint;
        private boolean m_moving;
        private Figure m_feedback;
        private Command m_moveCommand;

        public EntryFigure(IEntry entry) {
            this.m_entry = entry;
            if (this.m_entry.isEnabled()) {
                this.hookEvents();
            }
            PaletteComposite.setToolTip(this, this.m_entry.getText(), this.m_entry.getToolTipText());
            this.onPreferencesUpdate();
        }

        public void onPreferencesUpdate() {
            this.setFont(PaletteComposite.this.m_preferences.getEntryFont());
        }

        private void hookEvents() {
            this.addMouseListener(new IMouseListener(){

                public void mouseDoubleClick(MouseEvent event) {
                }

                public void mouseDown(MouseEvent event) {
                    if (event.button == 1) {
                        EntryFigure.this.m_mouseDown = true;
                        EntryFigure.this.m_mouseInside = true;
                        EntryFigure.this.setCapture(true);
                        EntryFigure.this.m_downPoint = new Point(event.x, event.y);
                        EntryFigure.this.m_moving = false;
                        EntryFigure.this.repaint();
                    }
                }

                public void mouseUp(MouseEvent event) {
                    if (event.button == 1 && EntryFigure.this.m_mouseDown) {
                        EntryFigure.this.m_mouseDown = false;
                        EntryFigure.this.setCapture(false);
                        if (EntryFigure.this.m_moving) {
                            EntryFigure.this.move_eraseFeedback();
                            if (EntryFigure.this.m_moveCommand != null) {
                                try {
                                    EntryFigure.this.m_moveCommand.execute();
                                }
                                catch (Throwable throwable) {}
                            }
                        } else if (EntryFigure.this.m_mouseInside) {
                            boolean reload = (event.stateMask & 0x40000) != 0;
                            PaletteComposite.this.selectEntry(EntryFigure.this.m_entry, reload);
                        }
                    }
                    EntryFigure.this.repaint();
                }
            });
            this.addMouseMoveListener(new IMouseMoveListener(){

                public void mouseMove(MouseEvent event) {
                    boolean oldMouseInside = EntryFigure.this.m_mouseInside;
                    EntryFigure.this.m_mouseInside = EntryFigure.this.getClientArea().contains(event.x, event.y);
                    if (EntryFigure.this.m_mouseDown) {
                        Point p = new Point(event.x, event.y);
                        if (!EntryFigure.this.m_moving && EntryFigure.this.m_downPoint.getDistance(p) > 4.0) {
                            EntryFigure.this.m_moving = true;
                        }
                        if (EntryFigure.this.m_moving) {
                            EntryFigure.this.move_showFeedback(p);
                        }
                    } else if (EntryFigure.this.m_mouseInside != oldMouseInside) {
                        EntryFigure.this.repaint();
                    }
                }
            });
            this.addMouseTrackListener(new IMouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    EntryFigure.this.m_mouseInside = true;
                    EntryFigure.this.repaint();
                }

                public void mouseExit(MouseEvent e) {
                    EntryFigure.this.m_mouseInside = false;
                    EntryFigure.this.repaint();
                }

                public void mouseHover(MouseEvent e) {
                }
            });
        }

        private void move_showFeedback(Point p) {
            this.move_eraseFeedback();
            this.m_moveCommand = null;
            Figure targetFigure = PaletteComposite.this.getTargetFigure(this, p);
            if (targetFigure instanceof EntryFigure) {
                EntryFigure targetEntryFigure = (EntryFigure)targetFigure;
                CategoryFigure targetCategoryFigure = (CategoryFigure)targetFigure.getParent();
                ICategory targetCategory = targetCategoryFigure.m_category;
                IEntry targetEntry = targetEntryFigure.m_entry;
                Point targetLocation = p.getCopy();
                FigureUtils.translateFigureToFigure2(this, targetFigure, targetLocation);
                if (targetCategoryFigure.m_columns == 1) {
                    Point feedbackLocation;
                    if (targetLocation.y < targetFigure.getSize().height / 2) {
                        feedbackLocation = targetFigure.getBounds().getLocation();
                        this.move_commandBefore(targetCategory, targetEntry);
                    } else {
                        feedbackLocation = targetFigure.getBounds().getBottomLeft();
                        this.move_commandAfter(targetCategory, targetEntry);
                    }
                    FigureUtils.translateFigureToAbsolute(targetFigure, feedbackLocation);
                    this.m_feedback = new FeedbackLine(PaletteComposite.this.m_feedbackLayer, true, feedbackLocation, targetFigure.getSize().width);
                } else {
                    Point feedbackLocation;
                    if (targetLocation.x < targetFigure.getSize().width / 2) {
                        feedbackLocation = targetFigure.getBounds().getLocation();
                        this.move_commandBefore(targetCategory, targetEntry);
                    } else {
                        feedbackLocation = targetFigure.getBounds().getTopRight();
                        this.move_commandAfter(targetCategory, targetEntry);
                    }
                    FigureUtils.translateFigureToAbsolute(targetFigure, feedbackLocation);
                    this.m_feedback = new FeedbackLine(PaletteComposite.this.m_feedbackLayer, false, feedbackLocation, targetFigure.getSize().height);
                }
            } else if (targetFigure instanceof CategoryFigure) {
                final ICategory targetCategory = ((CategoryFigure)targetFigure).m_category;
                this.m_feedback = new Figure();
                this.m_feedback.setBorder(new LineBorder(IColorConstants.menuBackgroundSelected, 2));
                Rectangle feedbackBounds = targetFigure.getBounds().getCopy();
                FigureUtils.translateFigureToAbsolute(targetFigure, feedbackBounds);
                this.m_feedback.setBounds(feedbackBounds);
                PaletteComposite.this.m_feedbackLayer.add(this.m_feedback);
                this.m_moveCommand = new Command(){

                    public void execute() throws Exception {
                        PaletteComposite.this.m_palette.moveEntry(EntryFigure.this.m_entry, targetCategory, null);
                    }
                };
            }
        }

        private void move_commandBefore(final ICategory targetCategory, final IEntry targetEntry) {
            this.m_moveCommand = new Command(){

                public void execute() throws Exception {
                    if (EntryFigure.this.m_entry != targetEntry) {
                        PaletteComposite.this.m_palette.moveEntry(EntryFigure.this.m_entry, targetCategory, targetEntry);
                    }
                }
            };
        }

        private void move_commandAfter(final ICategory targetCategory, final IEntry targetEntry) {
            this.m_moveCommand = new Command(){

                public void execute() throws Exception {
                    if (EntryFigure.this.m_entry != targetEntry) {
                        IEntry targetEntry2 = GenericsUtils.getNextOrNull(targetCategory.getEntries(), targetEntry);
                        if (EntryFigure.this.m_entry != targetEntry2) {
                            PaletteComposite.this.m_palette.moveEntry(EntryFigure.this.m_entry, targetCategory, targetEntry2);
                        }
                    }
                }
            };
        }

        private void move_eraseFeedback() {
            if (this.m_feedback != null) {
                this.m_feedback.getParent().remove(this.m_feedback);
                this.m_feedback = null;
            }
        }

        public Dimension getIconSize() {
            org.eclipse.swt.graphics.Rectangle imageBounds = this.getIcon().getBounds();
            int width = 3 + imageBounds.width + 6;
            int height = 3 + imageBounds.height + 3;
            return new Dimension(width, height);
        }

        public Dimension getIconTextSize() {
            org.eclipse.swt.graphics.Rectangle imageBounds = this.getIcon().getBounds();
            org.eclipse.swt.graphics.Point textExtent = PaletteComposite.this.m_paletteGC.textExtent(this.m_entry.getText());
            int width = 3 + imageBounds.width + 2 + textExtent.x + 6;
            int height = 3 + Math.max(imageBounds.height, textExtent.y) + 3;
            return new Dimension(width, height);
        }

        protected void paintClientArea(Graphics graphics) {
            boolean isSelected;
            Rectangle r = this.getClientArea().getCopy().shrink(1, 1);
            graphics.pushState();
            boolean bl = isSelected = this.m_entry == PaletteComposite.this.m_selectedEntry;
            if (isSelected || this.m_mouseDown) {
                if (isSelected) {
                    graphics.setBackgroundColor(COLOR_ENTRY_SELECTED);
                    graphics.fillRectangle(r);
                }
                PaletteComposite.drawRectangle3D(graphics, r, false);
                r.moveX(1);
                r.moveY(1);
            } else if (this.m_mouseInside) {
                PaletteComposite.drawRectangle3D(graphics, r, true);
            }
            graphics.popState();
            graphics.pushState();
            if (this.m_entry.isEnabled()) {
                this.paintClientArea_enabled(graphics, r);
            } else {
                this.paintClientArea_disabled(graphics, r);
            }
            graphics.popState();
        }

        private void paintClientArea_enabled(Graphics graphics, Rectangle r) {
            int x = r.x + 3;
            Image icon = this.getIcon();
            PaletteComposite.drawImageCV(graphics, icon, x, r.y, r.height);
            x += icon.getBounds().width + 2;
            if (!PaletteComposite.this.m_preferences.isOnlyIcons()) {
                graphics.setForegroundColor(COLOR_TEXT_ENABLED);
                PaletteComposite.drawStringCV(graphics, this.m_entry.getText(), x, r.y, r.width - x, r.height);
            }
        }

        private void paintClientArea_disabled(Graphics graphics, Rectangle r) {
            int x = r.x + 3;
            Image icon = this.getIcon();
            Image disabledIcon = new Image(null, icon, 1);
            try {
                PaletteComposite.drawImageCV(graphics, disabledIcon, x, r.y, r.height);
                x += disabledIcon.getBounds().width + 2;
            }
            finally {
                disabledIcon.dispose();
            }
            if (!PaletteComposite.this.m_preferences.isOnlyIcons()) {
                graphics.setForegroundColor(COLOR_TEXT_DISABLED);
                PaletteComposite.drawStringCV(graphics, this.m_entry.getText(), x, r.y, r.width - x, r.height);
            }
        }

        private Image getIcon() {
            Image icon = this.m_entry.getIcon();
            if (icon != null && !icon.isDisposed()) {
                return icon;
            }
            return NO_ICON;
        }
    }

    private static final class FeedbackLine
    extends Figure {
        private final boolean m_horizontal;

        public FeedbackLine(Figure parent, boolean horizontal, Point location, int size) {
            Rectangle bounds;
            this.m_horizontal = horizontal;
            parent.add(this);
            if (horizontal) {
                bounds = new Rectangle(location.x, location.y - 3, size, 6);
                bounds.y = Math.max(bounds.y, 0);
                bounds.y = Math.min(bounds.y, parent.getClientArea().height - 6);
            } else {
                bounds = new Rectangle(location.x - 3, location.y, 6, size);
                bounds.x = Math.max(bounds.x, 0);
                bounds.x = Math.min(bounds.x, parent.getClientArea().width - 6);
            }
            this.setBounds(bounds);
        }

        protected void paintClientArea(Graphics graphics) {
            Rectangle clientArea = this.getClientArea();
            if (this.m_horizontal) {
                int x = 0;
                graphics.drawLine(x, 0, x, 5);
                graphics.drawLine(++x, 1, x, 4);
                x = clientArea.right() - 1;
                graphics.drawLine(x, 0, x, 5);
                graphics.drawLine(--x, 1, x, 4);
                graphics.setLineWidth(2);
                graphics.drawLine(0, 3, clientArea.width, 3);
            } else {
                int y = 0;
                graphics.drawLine(0, y, 5, y);
                graphics.drawLine(1, ++y, 4, y);
                y = clientArea.height - 1;
                graphics.drawLine(0, y, 5, y);
                graphics.drawLine(1, --y, 4, y);
                graphics.setLineWidth(2);
                graphics.drawLine(3, 2, 3, clientArea.height);
            }
        }
    }

    private final class PaletteFigure
    extends Layer {
        public PaletteFigure() {
            super("palette");
        }

        public void refresh() {
            PaletteComposite.this.m_categoryFigures.clear();
            this.removeAll();
            for (ICategory category : PaletteComposite.this.m_palette.getCategories()) {
                CategoryFigure categoryFigure = new CategoryFigure(category);
                PaletteComposite.this.m_categoryFigures.put(category, categoryFigure);
                this.add(categoryFigure);
            }
            this.layout();
        }

        public void setBounds(Rectangle bounds) {
            super.setBounds(bounds);
            this.layout();
        }

        private void onPreferencesUpdate() {
            for (CategoryFigure categoryFigure : this.getChildren()) {
                categoryFigure.onPreferencesUpdate();
            }
            this.layout();
        }

        private void layout() {
            int width = ((PaletteComposite)PaletteComposite.this).m_figureCanvas.getClientArea().width;
            width -= this.getInsets().getWidth();
            int y = 0;
            for (CategoryFigure categoryFigure : this.getChildren()) {
                y += categoryFigure.layout(y, width);
            }
        }
    }
}

