/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.editor.actions.assistant;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.wb.core.editor.actions.assistant.AbstractAssistantPage;
import org.eclipse.wb.core.editor.actions.assistant.ILayoutAssistantPage;
import org.eclipse.wb.core.editor.actions.assistant.LayoutAssistantListener;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.utils.ui.TabFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutAssistantSupport {
    public LayoutAssistantSupport(ObjectInfo layout) {
        layout.addBroadcastListener(new LayoutAssistantListener(){

            @Override
            public void createAssistantPages(List<ObjectInfo> objects, TabFolder folder, List<ILayoutAssistantPage> pages) throws Exception {
                LayoutAssistantSupport.this.createAssistantPages(objects, folder, pages);
            }
        });
    }

    private void createAssistantPages(List<ObjectInfo> objects, TabFolder folder, List<ILayoutAssistantPage> pages) throws Exception {
        ObjectInfo firstObject = objects.get(0);
        ObjectInfo container = this.getContainer();
        if (objects.size() == 1 && firstObject == container) {
            LayoutAssistantSupport.addPage(folder, pages, Messages.LayoutAssistantSupport_layoutPage, this.createLayoutPage((Composite)folder));
            return;
        }
        if (firstObject.getParent() == container) {
            LayoutAssistantSupport.addPage(folder, pages, Messages.LayoutAssistantSupport_parentLayoutPage, this.createLayoutPage((Composite)folder));
            LayoutAssistantSupport.addPage(folder, pages, this.getConstraintsPageTitle(), this.createConstraintsPage((Composite)folder, objects));
        }
    }

    protected abstract ObjectInfo getContainer();

    private static void addPage(TabFolder folder, List<ILayoutAssistantPage> pages, String name, AbstractAssistantPage page) {
        if (page != null) {
            TabFactory.item(folder).text(name).control((Control)page);
            pages.add(page);
        }
    }

    protected AbstractAssistantPage createLayoutPage(Composite parent) {
        return null;
    }

    protected AbstractAssistantPage createConstraintsPage(Composite parent, List<ObjectInfo> objects) {
        return null;
    }

    protected abstract String getConstraintsPageTitle();
}

