/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gefTree.part;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.model.util.ObjectsLabelProvider;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.gef.tree.TreeViewer;
import org.eclipse.wb.internal.gef.tree.policies.AutoExpandEditPolicy;
import org.eclipse.wb.internal.gef.tree.policies.SelectionEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEditPart
extends TreeEditPart {
    private final ObjectInfo m_object;
    private Listener m_updatePresentationListener;
    private boolean m_updateRequired;

    public ObjectEditPart(ObjectInfo object) {
        this.m_object = object;
        this.setModel(this.m_object);
    }

    @Override
    public void activate() {
        super.activate();
        if (this.m_object.isRoot()) {
            final TreeViewer viewer = (TreeViewer)this.getViewer();
            final Tree tree = viewer.getTree();
            this.m_updatePresentationListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.item.getData() instanceof ObjectEditPart) {
                        ObjectEditPart editPart = (ObjectEditPart)event.item.getData();
                        editPart.update();
                    }
                }
            };
            tree.addListener(42, this.m_updatePresentationListener);
            this.m_object.addBroadcastListener(new ObjectEventListener(){
                private List<ObjectInfo> m_delayedSelectionObjects;

                @Override
                public void refreshed() throws Exception {
                    tree.setRedraw(false);
                    try {
                        ObjectEditPart.this.refresh();
                        this.setSelectionIfAllEditParts(this.m_delayedSelectionObjects);
                        this.m_delayedSelectionObjects = null;
                        viewer.setSelectionToTreeWidget();
                    }
                    finally {
                        tree.setRedraw(true);
                    }
                }

                @Override
                public void select(List<? extends ObjectInfo> objects) throws Exception {
                    this.m_delayedSelectionObjects = null;
                    if (!this.setSelectionIfAllEditParts(objects)) {
                        this.m_delayedSelectionObjects = Lists.newArrayList(objects);
                    }
                }

                private boolean setSelectionIfAllEditParts(List<? extends ObjectInfo> objects) {
                    List<EditPart> editParts = this.getAllEditParts(objects);
                    if (editParts == null) {
                        return false;
                    }
                    viewer.setSelection(editParts);
                    return true;
                }

                private List<EditPart> getAllEditParts(List<? extends ObjectInfo> objects) {
                    if (objects == null) {
                        return null;
                    }
                    ArrayList editParts = Lists.newArrayList();
                    for (ObjectInfo objectInfo : objects) {
                        EditPart editPart = viewer.getEditPartByModel(objectInfo);
                        if (editPart == null) {
                            return null;
                        }
                        editParts.add(editPart);
                    }
                    return editParts;
                }
            });
        }
    }

    @Override
    public void deactivate() {
        if (this.m_updatePresentationListener != null) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            Tree tree = viewer.getTree();
            tree.removeListener(42, this.m_updatePresentationListener);
        }
        super.deactivate();
    }

    @Override
    protected final void refreshVisuals() {
        this.m_updateRequired = true;
    }

    private void update() {
        if (this.m_updateRequired) {
            this.m_updateRequired = false;
            ExecutionUtils.runLogUI(new RunnableEx(){

                public void run() throws Exception {
                    ObjectEditPart.this.update0();
                }
            });
        }
    }

    private void update0() {
        Image image = ObjectsLabelProvider.INSTANCE.getImage(this.m_object);
        String text = ObjectsLabelProvider.INSTANCE.getText(this.m_object);
        if (image != null && !image.isDisposed()) {
            this.getWidget().setImage(image);
        }
        this.getWidget().setText(text);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", new SelectionEditPolicy());
        this.installEditPolicy(new AutoExpandEditPolicy());
        this.refreshEditPolicies();
    }

    protected void refreshEditPolicies() {
    }

    @Override
    protected List<?> getModelChildren() {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx<List<?>>(){

            @Override
            public List<?> runObject() throws Exception {
                return ObjectEditPart.this.m_object.getPresentation().getChildrenTree();
            }
        }, Collections.emptyList());
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshEditPolicies();
    }
}

