/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.broadcast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BroadcastSupport {
    private final Map<Class<?>, List<Object>> m_classToListeners = Maps.newHashMap();
    private final Map<ObjectInfo, List<Object>> m_targetToListeners = Maps.newHashMap();
    private final Map<Class<?>, Object> m_listenerToMulticast = Maps.newHashMap();

    public void addListener(ObjectInfo target, Object listenerImpl) {
        Class<?> listenerClass = BroadcastSupport.getListenerClass(listenerImpl);
        BroadcastSupport.addListener(this.getClassListeners(listenerClass), listenerImpl);
        if (target != null) {
            BroadcastSupport.addListener(this.getTargetListeners(target), listenerImpl);
        }
    }

    public void removeListener(ObjectInfo target, Object listenerImpl) {
        Class<?> listenerClass = BroadcastSupport.getListenerClass(listenerImpl);
        this.getClassListeners(listenerClass).remove(listenerImpl);
        if (target != null) {
            this.getTargetListeners(target).remove(listenerImpl);
        }
    }

    public void targetListener(ObjectInfo oldTarget, ObjectInfo newTarget) {
        List<Object> listeners = this.m_targetToListeners.remove(oldTarget);
        if (listeners != null) {
            this.getTargetListeners(newTarget).addAll(listeners);
        }
    }

    public void cleanUpTargets(ObjectInfo root) {
        ArrayList<ObjectInfo> targets = new ArrayList<ObjectInfo>(this.m_targetToListeners.keySet());
        for (ObjectInfo target : targets) {
            if (root.isItOrParentOf(target)) continue;
            this.cleanUpTarget(target);
        }
    }

    private static Class<?> getListenerClass(Object listenerImpl) {
        Class<?> implClass = listenerImpl.getClass();
        Class<?> listenerClass = implClass.getSuperclass();
        if (listenerClass != Object.class) {
            while (listenerClass.getSuperclass() != Object.class) {
                listenerClass = listenerClass.getSuperclass();
            }
            return listenerClass;
        }
        Class<?>[] interfaces = implClass.getInterfaces();
        if (EnvironmentUtils.DEVELOPER_HOST) {
            Assert.isTrue(interfaces.length == 1, "Only one listener interface expected, but %s found.", interfaces.length);
        }
        return interfaces[0];
    }

    private List<Object> getClassListeners(Class<?> listenerClass) {
        ArrayList listeners = this.m_classToListeners.get(listenerClass);
        if (listeners == null) {
            listeners = Lists.newArrayList();
            this.m_classToListeners.put(listenerClass, listeners);
        }
        return listeners;
    }

    private List<Object> getTargetListeners(ObjectInfo target) {
        ArrayList listeners = this.m_targetToListeners.get(target);
        if (listeners == null) {
            listeners = Lists.newArrayList();
            this.m_targetToListeners.put(target, listeners);
        }
        return listeners;
    }

    private static void addListener(List<Object> listeners, Object listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    private void cleanUpTarget(ObjectInfo target) {
        ArrayList<Object> listeners = new ArrayList<Object>(this.getTargetListeners(target));
        for (Object e : listeners) {
            this.removeListener(target, e);
        }
        this.m_targetToListeners.remove(target);
    }

    public <T> T getListener(final Class<T> listenerClass) {
        Object listenerMulticast = this.m_listenerToMulticast.get(listenerClass);
        if (listenerMulticast == null) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(listenerClass);
            enhancer.setCallback((Callback)new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    List listeners = BroadcastSupport.this.getClassListeners(listenerClass);
                    Object[] objectArray = listeners.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        try {
                            method.invoke(listener, args);
                        }
                        catch (InvocationTargetException e) {
                            throw e.getCause();
                        }
                        ++n2;
                    }
                    return null;
                }
            });
            listenerMulticast = enhancer.create();
            this.m_listenerToMulticast.put(listenerClass, listenerMulticast);
        }
        Object casted_listenerMulticast = listenerMulticast;
        return (T)casted_listenerMulticast;
    }
}

