/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.describer;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.describer.TextContentDescriber;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSourceUiDescriber
extends TextContentDescriber {
    @Override
    public int describe(Reader contents, IContentDescription description) throws IOException {
        String source = IOUtils.toString((Reader)contents);
        return JavaSourceUiDescriber.isGUISource(source) ? 2 : 0;
    }

    @Override
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        String source = IOUtils.toString((InputStream)contents);
        return JavaSourceUiDescriber.isGUISource(source) ? 2 : 0;
    }

    private static boolean isGUISource(String source) {
        if (DesignerPlugin.getDefault() == null) {
            return false;
        }
        if (!DesignerPlugin.getPreferences().getBoolean("editor.recognizeSourceGUI")) {
            return false;
        }
        if (!JavaSourceUiDescriber.hasIncludePattern(source)) {
            return false;
        }
        return !JavaSourceUiDescriber.hasExcludePattern(source);
    }

    private static boolean hasIncludePattern(String source) {
        for (String pattern : JavaSourceUiDescriber.getIncludePatterns()) {
            if (source.indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExcludePattern(String source) {
        for (String pattern : JavaSourceUiDescriber.getExcludePatterns()) {
            if (source.indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    private static List<String> getIncludePatterns() {
        return JavaSourceUiDescriber.getPatterns("includePattern");
    }

    private static List<String> getExcludePatterns() {
        return JavaSourceUiDescriber.getPatterns("excludePattern");
    }

    private static List<String> getPatterns(String elementName) {
        ArrayList patterns = Lists.newArrayList();
        List<IConfigurationElement> elements = ExternalFactoriesHelper.getElements("org.eclipse.wb.core.designerContentPatterns", elementName);
        for (IConfigurationElement element : elements) {
            String pattern = element.getValue();
            patterns.add(pattern);
        }
        return patterns;
    }
}

