/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.grid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.util.grid.GridConvertionHelper;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGridConverter {
    public static void convert(IGridLayoutContainer container, IGridLayoutInstance layout) throws Exception {
        List<GridConvertionHelper.ComponentGroup> columns = GridConvertionHelper.buildGroups(container.getControls(), true);
        List<GridConvertionHelper.ComponentGroup> rows = GridConvertionHelper.buildGroups(container.getControls(), false);
        GridConvertionHelper.sortGroupsByTranspose(columns, rows);
        GridConvertionHelper.sortGroupsByTranspose(rows, columns);
        GridConvertionHelper.sortGroups(columns);
        GridConvertionHelper.sortGroups(rows);
        GridConvertionHelper.updateBoundsGaps(columns, false);
        GridConvertionHelper.updateBoundsGaps(rows, false);
        AbstractGridConverter.reorderControls(container, rows);
        int numColumns = columns.size();
        ArrayList appliedControls = Lists.newArrayList();
        for (GridConvertionHelper.ComponentGroup column : columns) {
            for (GridConvertionHelper.ComponentInGroup component : column.getComponents()) {
                IAbstractComponentInfo control = component.getComponent();
                if (appliedControls.contains(control)) continue;
                GeneralLayoutData generalLayoutData = GeneralLayoutData.getFromInfoEx(control.getUnderlyingModel());
                IGridLayoutData gridData = layout.getLayoutData(control);
                Rectangle cells = AbstractGridConverter.getCells(component, generalLayoutData, columns, rows);
                gridData.setGridX(cells.x);
                gridData.setGridY(cells.y);
                gridData.setSpanX(cells.width);
                gridData.setSpanY(cells.height);
                AbstractGridConverter.applyGeneralLayoutData(gridData, generalLayoutData);
                appliedControls.add(control);
                numColumns = Math.max(numColumns, cells.x + cells.width);
            }
        }
        if (numColumns > 0) {
            layout.setColumnCount(numColumns);
        }
        layout.applyChanges();
    }

    protected static Rectangle getCells(GridConvertionHelper.ComponentInGroup component, GeneralLayoutData generalLayoutData, List<GridConvertionHelper.ComponentGroup> columns, List<GridConvertionHelper.ComponentGroup> rows) {
        int x = -1;
        int y = -1;
        int w = 1;
        int h = 1;
        GridConvertionHelper.ComponentGroup beginColumn = GridConvertionHelper.getBeginForComponent(columns, component);
        GridConvertionHelper.ComponentGroup endColumn = GridConvertionHelper.getEndForComponent(columns, component);
        GridConvertionHelper.ComponentGroup beginRow = GridConvertionHelper.getBeginForComponent(rows, component);
        GridConvertionHelper.ComponentGroup endRow = GridConvertionHelper.getEndForComponent(rows, component);
        x = columns.indexOf(beginColumn);
        y = rows.indexOf(beginRow);
        w = 1 + columns.indexOf(endColumn) - x;
        h = 1 + rows.indexOf(endRow) - y;
        if (generalLayoutData.gridX != null) {
            x = generalLayoutData.gridX;
            w = 1;
        }
        if (generalLayoutData.gridY != null) {
            y = generalLayoutData.gridY;
            h = 1;
        }
        if (generalLayoutData.spanX != null) {
            w = generalLayoutData.spanX;
        }
        if (generalLayoutData.spanY != null) {
            h = generalLayoutData.spanY;
        }
        return new Rectangle(x, y, w, h);
    }

    protected static void applyGeneralLayoutData(IGridLayoutData gridData, GeneralLayoutData generalLayoutData) throws Exception {
        if (generalLayoutData.horizontalGrab != null) {
            gridData.setHorizontalGrab(generalLayoutData.horizontalGrab);
        }
        if (generalLayoutData.verticalGrab != null) {
            gridData.setVerticalGrab(generalLayoutData.verticalGrab);
        }
        if (generalLayoutData.horizontalAlignment != null) {
            gridData.setHorizontalAlignment(generalLayoutData.horizontalAlignment);
        }
        if (generalLayoutData.verticalAlignment != null) {
            gridData.setVerticalAlignment(generalLayoutData.verticalAlignment);
        }
    }

    protected static void reorderControls(IGridLayoutContainer container, List<GridConvertionHelper.ComponentGroup> rows) throws Exception {
        ArrayList reversedControls = Lists.newArrayList();
        for (GridConvertionHelper.ComponentGroup row : rows) {
            for (GridConvertionHelper.ComponentInGroup componentInGroup : row.getComponents()) {
                IAbstractComponentInfo control = componentInGroup.getComponent();
                reversedControls.add(0, control);
            }
        }
        IAbstractComponentInfo nextControl = null;
        for (IAbstractComponentInfo control : reversedControls) {
            if (nextControl != null) {
                boolean alreadyRightOrder;
                boolean bl = alreadyRightOrder = GenericsUtils.getNextOrNull(container.getControls(), control) == nextControl;
                if (!alreadyRightOrder) {
                    GlobalState.getOrderProcessor().move(control, nextControl);
                }
            }
            nextControl = control;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IGridLayoutContainer {
        public IAbstractComponentInfo getComponent();

        public List<IAbstractComponentInfo> getControls();
    }

    public static interface IGridLayoutData {
        public IAbstractComponentInfo getComponent();

        public IGridLayoutInstance getLayout();

        public void setGridX(int var1) throws Exception;

        public void setGridY(int var1) throws Exception;

        public void setSpanX(int var1) throws Exception;

        public void setSpanY(int var1) throws Exception;

        public void setHorizontalGrab(boolean var1) throws Exception;

        public void setVerticalGrab(boolean var1) throws Exception;

        public void setHorizontalAlignment(GeneralLayoutData.HorizontalAlignment var1) throws Exception;

        public void setVerticalAlignment(GeneralLayoutData.VerticalAlignment var1) throws Exception;
    }

    public static interface IGridLayoutInstance {
        public IGridLayoutContainer getContainer();

        public IGridLayoutData getLayoutData(IAbstractComponentInfo var1);

        public void setColumnCount(int var1) throws Exception;

        public void applyChanges() throws Exception;
    }
}

