/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeClassLoader
extends ClassLoader {
    private final List<ClassLoader> m_classLoaders = Lists.newArrayList();
    private final List<List<String>> m_classNamespaces = Lists.newArrayList();
    private final List<List<String>> m_resourceNamespaces = Lists.newArrayList();

    public List<ClassLoader> getClassLoaders() {
        return this.m_classLoaders;
    }

    public void add(ClassLoader classLoader, List<String> namespaces) {
        this.add(classLoader, namespaces, namespaces);
    }

    public void add(ClassLoader classLoader, List<String> classPrefixes, List<String> resourcePrefixes) {
        if (classLoader != null) {
            this.m_classLoaders.add(0, classLoader);
            this.m_classNamespaces.add(0, classPrefixes);
            if (resourcePrefixes != null) {
                ArrayList resourceNamespaces = Lists.newArrayList();
                for (String namespace : resourcePrefixes) {
                    resourceNamespaces.add(namespace.replace('.', '/'));
                }
                this.m_resourceNamespaces.add(0, resourceNamespaces);
            } else {
                this.m_resourceNamespaces.add(0, null);
            }
        }
    }

    @Override
    protected Package getPackage(String name) {
        try {
            Method method_getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
            method_getPackage.setAccessible(true);
            int i = 0;
            while (i < this.m_classLoaders.size()) {
                ClassLoader classLoader = this.m_classLoaders.get(i);
                Package pkg = (Package)method_getPackage.invoke((Object)classLoader, name);
                if (pkg != null) {
                    return pkg;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
        return super.getPackage(name);
    }

    @Override
    public URL getResource(String name) {
        int i = 0;
        while (i < this.m_classLoaders.size()) {
            URL resource;
            ClassLoader classLoader = this.m_classLoaders.get(i);
            List<String> namespaces = this.m_resourceNamespaces.get(i);
            if (CompositeClassLoader.hasNamespace(name, namespaces) && (resource = classLoader.getResource(name)) != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        HashSet allResources = Sets.newHashSet();
        for (ClassLoader classLoader : this.m_classLoaders) {
            Enumeration<URL> resources = classLoader.getResources(name);
            CollectionUtils.addAll((Collection)allResources, resources);
        }
        return Iterators.asEnumeration(allResources.iterator());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        int i = 0;
        while (i < this.m_classLoaders.size()) {
            ClassLoader classLoader = this.m_classLoaders.get(i);
            List<String> namespaces = this.m_classNamespaces.get(i);
            if (CompositeClassLoader.hasNamespace(name, namespaces)) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++i;
        }
        throw new ClassNotFoundException(name);
    }

    private static boolean hasNamespace(String name, List<String> namespaces) {
        if (namespaces != null) {
            for (String namespace : namespaces) {
                if (!name.startsWith(namespace)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

