/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.model.reference.StringReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveDecoratingLabelProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.beans.ElPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ElPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ElPropertyUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColumnBindingUiContentProvider
implements IUiContentProvider {
    private Label propertiesLabel;
    private CheckboxTreeViewer treeViewer;
    private ElPropertyUiContentProvider elPropertyUIContentProvider;
    private boolean elProperty;
    private String errorMessage;
    private List<PropertyAdapter> properties = Collections.emptyList();
    private ICompleteListener listener;
    private final ColumnBindingInfo binding;

    public ColumnBindingUiContentProvider(ColumnBindingInfo binding) {
        this.binding = binding;
    }

    public void setCompleteListener(ICompleteListener listener) {
        this.listener = listener;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private final void setErrorMessage(String message) {
        this.errorMessage = message;
        if (this.listener != null) {
            this.listener.calculateFinish();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void createContent(Composite parent, int columns) {
        this.propertiesLabel = new Label(parent, 0);
        this.propertiesLabel.setText(Messages.ColumnBindingUiContentProvider_properties);
        this.treeViewer = new CheckboxTreeViewer(parent, 68352);
        this.treeViewer.setContentProvider((IContentProvider)new PropertyAdapterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PropertyAdapterLabelProvider((TreeViewer)this.treeViewer));
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ColumnBindingUiContentProvider.this.treeViewer.setCheckedElements(new Object[]{event.getElement()});
                }
                ColumnBindingUiContentProvider.this.calculateFinish();
            }
        });
        GridDataFactory.create((Control)this.treeViewer.getTree()).fill().grab().spanH(columns - 1).minVC(5);
        ElPropertyUiConfiguration configuration = new ElPropertyUiConfiguration();
        configuration.setTitle(Messages.ColumnBindingUiContentProvider_elExpression);
        this.elPropertyUIContentProvider = new ElPropertyUiContentProvider(configuration, null);
        this.elPropertyUIContentProvider.setCompleteListener(new ICompleteListener(){

            public void calculateFinish() {
                ColumnBindingUiContentProvider.this.calculateFinish();
            }
        });
        this.elPropertyUIContentProvider.createContent(parent, columns);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ColumnBindingUiContentProvider.this.handleELProperty();
            }
        });
    }

    private void calculateFinish() {
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        if (checkedElements.length == 0) {
            this.setErrorMessage(Messages.ColumnBindingUiContentProvider_erorrMessage);
        } else if (this.elProperty) {
            this.setErrorMessage(this.elPropertyUIContentProvider.getErrorMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    private void handleELProperty() {
        IGenericType objectType = this.binding.getJTableBinding().getInputElementType();
        try {
            ObservePropertyAdapter adapter;
            Object[] elements = this.treeViewer.getCheckedElements();
            if (this.elProperty) {
                ObservePropertyAdapter adapter2;
                if (elements.length == 1 && (adapter2 = (ObservePropertyAdapter)((Object)elements[0])).getProperty() instanceof ElPropertyObserveInfo) {
                    this.elPropertyUIContentProvider.setProperty((ElPropertyInfo)this.convertAdapterToProperty(new BeanSupport(), objectType, adapter2));
                    return;
                }
                this.elProperty = false;
                this.elPropertyUIContentProvider.setProperty(null);
            } else if (elements.length == 1 && (adapter = (ObservePropertyAdapter)((Object)elements[0])).getProperty() instanceof ElPropertyObserveInfo) {
                this.elProperty = true;
                this.elPropertyUIContentProvider.setProperty((ElPropertyInfo)this.convertAdapterToProperty(new BeanSupport(), objectType, adapter));
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    public void updateFromObject() throws Exception {
        IGenericType objectType = this.binding.getJTableBinding().getInputElementType();
        this.setObjectType(objectType);
        PropertyInfo property = this.binding.getDetailProperty();
        this.elProperty = property instanceof ElPropertyInfo;
        this.elPropertyUIContentProvider.setProperty(this.elProperty ? (ElPropertyInfo)property : null);
        ObservePropertyAdapter adapter = this.convertPropertyToAdapter(new BeanSupport(), objectType, property);
        this.setCheckedAdExpand(new Object[]{adapter});
        this.calculateFinish();
    }

    public void saveToObject() throws Exception {
        if (this.elProperty) {
            this.elPropertyUIContentProvider.saveToObject();
            this.binding.setDetailProperty(this.elPropertyUIContentProvider.getProperty());
        } else {
            IGenericType objectType = this.binding.getJTableBinding().getInputElementType();
            List<PropertyAdapter> choosenProperties = this.getChoosenProperties();
            PropertyAdapter propertyAdapter = choosenProperties.get(0);
            PropertyInfo property = this.convertAdapterToProperty(new BeanSupport(), objectType, (ObservePropertyAdapter)propertyAdapter);
            this.binding.setDetailProperty(property);
        }
    }

    protected void setObjectType(IGenericType objectType) {
        if (this.getErrorMessage() == null) {
            try {
                this.properties = this.getProperties(objectType);
                this.treeViewer.setInput(this.properties);
                if (!this.properties.isEmpty()) {
                    this.treeViewer.setCheckedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
                }
            }
            catch (Throwable throwable) {
                this.setEmptyProperties();
            }
        } else {
            this.setEmptyProperties();
        }
    }

    private void setEmptyProperties() {
        this.properties = Collections.emptyList();
        this.treeViewer.setInput(this.properties);
        this.treeViewer.setCheckedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    private void setCheckedAdExpand(Object ... adapters) {
        int i = 0;
        while (i < adapters.length) {
            this.treeViewer.expandToLevel(adapters[i], 0);
            ++i;
        }
        this.treeViewer.setCheckedElements(adapters);
        if (adapters.length > 0) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(adapters[0]), true);
        }
    }

    private List<PropertyAdapter> getChoosenProperties() {
        ArrayList properties = Lists.newArrayList();
        CollectionUtils.addAll((Collection)properties, (Object[])this.treeViewer.getCheckedElements());
        return properties;
    }

    private List<PropertyAdapter> getProperties(IGenericType objectType) throws Exception {
        ArrayList adapters = Lists.newArrayList();
        BeanSupport beanSupport = new BeanSupport();
        beanSupport.doAddELProperty(true);
        for (ObserveInfo property : beanSupport.createProperties(null, objectType)) {
            adapters.add(new ObservePropertyAdapter(null, property));
        }
        return adapters;
    }

    private PropertyInfo convertAdapterToProperty(BeanSupport beanSupport, IGenericType objectType, ObservePropertyAdapter adapter) throws Exception {
        SubBeanObserveInfo observe = new SubBeanObserveInfo(beanSupport, null, objectType, StringReferenceProvider.EMPTY);
        return adapter.getProperty().createProperty(observe);
    }

    private ObservePropertyAdapter convertPropertyToAdapter(BeanSupport beanSupport, IGenericType objectType, PropertyInfo property) throws Exception {
        ObserveInfo observe = property.getObserveProperty(new SubBeanObserveInfo(beanSupport, null, objectType, StringReferenceProvider.EMPTY));
        Assert.isNotNull((Object)observe);
        return this.convertObserveToAdapter(observe);
    }

    private ObservePropertyAdapter convertObserveToAdapter(ObserveInfo observe) throws Exception {
        if (observe != null) {
            ObservePropertyAdapter adapter = new ObservePropertyAdapter(this.convertObserveToAdapter((ObserveInfo)observe.getParent()), observe);
            adapter.addToParent();
            return adapter;
        }
        return null;
    }

    private static ObservePropertyAdapter getAdapter(Object element) {
        return (ObservePropertyAdapter)((Object)element);
    }

    private static ObserveInfo getAdapterProperty(Object element) {
        return ColumnBindingUiContentProvider.getAdapter(element).getProperty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObservePropertyAdapter
    extends PropertyAdapter {
        private final ObservePropertyAdapter m_parent;
        private final ObserveInfo m_property;
        private List<ObservePropertyAdapter> m_children;

        public ObservePropertyAdapter(ObservePropertyAdapter parent, ObserveInfo property) throws Exception {
            super(property.getPresentation().getText(), property.getObjectClass());
            this.m_parent = parent;
            this.m_property = property;
        }

        public ObservePropertyAdapter getParent() {
            return this.m_parent;
        }

        public ObserveInfo getProperty() {
            return this.m_property;
        }

        public List<ObservePropertyAdapter> getChildren() {
            if (this.m_children == null) {
                this.m_children = Lists.newArrayList();
                List properties = CoreUtils.cast((List)this.m_property.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
                for (ObserveInfo property : properties) {
                    try {
                        this.m_children.add(new ObservePropertyAdapter(this, property));
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
            }
            return this.m_children;
        }

        public void addToParent() {
            if (this.m_parent != null) {
                this.m_parent.m_children = Lists.newArrayList();
                this.m_parent.m_children.add(this);
            }
        }

        public int hashCode() {
            int parentHash = this.m_parent == null ? 1 : this.m_parent.hashCode();
            return parentHash * super.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ObservePropertyAdapter) {
                ObservePropertyAdapter adapter = (ObservePropertyAdapter)((Object)object);
                if (this.m_parent != null || adapter.m_parent != null) {
                    if (this.m_parent != null && adapter.m_parent == null || this.m_parent == null && adapter.m_parent != null) {
                        return false;
                    }
                    if (this.m_parent != null && adapter.m_parent != null && !this.m_parent.equals((Object)adapter.m_parent)) {
                        return false;
                    }
                }
                return this.m_name.equals(adapter.m_name) && this.m_type == adapter.m_type;
            }
            return false;
        }
    }

    private static class PropertyAdapterContentProvider
    implements ITreeContentProvider {
        private PropertyAdapterContentProvider() {
        }

        public Object[] getElements(Object input) {
            return ((List)input).toArray();
        }

        public Object getParent(Object element) {
            return ColumnBindingUiContentProvider.getAdapter(element).getParent();
        }

        public boolean hasChildren(Object element) {
            return !ColumnBindingUiContentProvider.getAdapter(element).getChildren().isEmpty();
        }

        public Object[] getChildren(Object element) {
            return ColumnBindingUiContentProvider.getAdapter(element).getChildren().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class PropertyAdapterLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        private final ObserveDecoratingLabelProvider m_labelProvider;

        public PropertyAdapterLabelProvider(TreeViewer viewer) {
            this.m_labelProvider = new ObserveDecoratingLabelProvider((StructuredViewer)viewer);
        }

        public void dispose() {
            super.dispose();
            this.m_labelProvider.dispose();
        }

        public String getText(Object element) {
            return ColumnBindingUiContentProvider.getAdapter(element).getName();
        }

        public Image getImage(Object element) {
            try {
                return ColumnBindingUiContentProvider.getAdapterProperty(element).getPresentation().getImage();
            }
            catch (Throwable throwable) {
                return super.getImage(element);
            }
        }

        public Color getForeground(Object element) {
            return this.m_labelProvider.getForeground((Object)ColumnBindingUiContentProvider.getAdapterProperty(element));
        }

        public Color getBackground(Object element) {
            return this.m_labelProvider.getBackground((Object)ColumnBindingUiContentProvider.getAdapterProperty(element));
        }

        public Font getFont(Object element) {
            return this.m_labelProvider.getFont((Object)ColumnBindingUiContentProvider.getAdapterProperty(element));
        }
    }

    private static class SubBeanObserveInfo
    extends BeanObserveInfo {
        public SubBeanObserveInfo(BeanSupport beanSupport, ObserveInfo parent, IGenericType objectType, IReferenceProvider referenceProvider) {
            super(beanSupport, parent, objectType, referenceProvider);
        }

        public IObservePresentation getPresentation() {
            return null;
        }
    }
}

