/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.CellVisualChangeEvent;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.painter.cell.decorator.BeveledBorderDecorator;
import net.sourceforge.nattable.ui.NatEventData;
import net.sourceforge.nattable.ui.action.IMouseAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ButtonCellPainter
implements ICellPainter,
IMouseAction {
    private final ICellPainter buttonRaisedPainter;
    private final ICellPainter buttonPressedPainter;
    private int buttonFlashTime = 150;
    private int columnPosClicked;
    private int rowPosClicked;
    private boolean recentlyClicked;
    private final List<IMouseAction> clickLiseners = new ArrayList<IMouseAction>();

    public ButtonCellPainter(ICellPainter interiorPainter) {
        this.buttonPressedPainter = interiorPainter;
        this.buttonRaisedPainter = new BeveledBorderDecorator(interiorPainter);
    }

    public ButtonCellPainter(ICellPainter buttonRaisedPainter, ICellPainter buttonPressedPainter) {
        this.buttonRaisedPainter = buttonRaisedPainter;
        this.buttonPressedPainter = buttonPressedPainter;
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        if (this.recentlyClicked && this.columnPosClicked == cell.getColumnPosition() && this.rowPosClicked == cell.getRowPosition()) {
            this.buttonPressedPainter.paintCell(cell, gc, bounds, configRegistry);
        } else {
            this.buttonRaisedPainter.paintCell(cell, gc, bounds, configRegistry);
        }
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return cell.getBounds().height;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return cell.getBounds().width;
    }

    private TimerTask getButtonFlashTimerTask(final ILayer layer) {
        return new TimerTask(){

            public void run() {
                ButtonCellPainter.this.recentlyClicked = false;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        layer.fireLayerEvent(new CellVisualChangeEvent(layer, ButtonCellPainter.this.columnPosClicked, ButtonCellPainter.this.rowPosClicked));
                    }
                });
            }
        };
    }

    public void run(NatTable natTable, MouseEvent event) {
        NatEventData eventData = (NatEventData)event.data;
        this.columnPosClicked = eventData.getColumnPosition();
        this.rowPosClicked = eventData.getRowPosition();
        this.recentlyClicked = true;
        new Timer().schedule(this.getButtonFlashTimerTask(natTable), this.buttonFlashTime);
        natTable.fireLayerEvent(new CellVisualChangeEvent(natTable, this.columnPosClicked, this.rowPosClicked));
        for (IMouseAction listener : this.clickLiseners) {
            listener.run(natTable, event);
        }
    }

    public void addClickListener(IMouseAction mouseAction) {
        this.clickLiseners.add(mouseAction);
    }

    public void removeClickListener(IMouseAction mouseAction) {
        this.clickLiseners.remove(mouseAction);
    }

    public void setButtonFlashTime(int flashTimeInMS) {
        this.buttonFlashTime = flashTimeInMS;
    }
}

