/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.IGroupStructureProvider;
import org.eclipse.birt.report.model.api.DataGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;

public abstract class AbstractGroupStructureProvider
implements IGroupStructureProvider {
    private String groupPropertyName;

    protected AbstractGroupStructureProvider(String groupPropertyName) {
        this.groupPropertyName = groupPropertyName;
    }

    @Override
    public List<GroupHandle> getGroups(DesignElementHandle handle) {
        List glist;
        PropertyHandle propHandle;
        if (handle != null && (propHandle = handle.getPropertyHandle(this.groupPropertyName)) != null && (glist = propHandle.getContents()).size() > 0) {
            ArrayList<GroupHandle> clist = new ArrayList<GroupHandle>();
            ElementFactory factory = new ElementFactory(handle.getModule());
            for (Object dg : glist) {
                GroupHandle cg;
                if (dg instanceof GroupHandle) {
                    clist.add((GroupHandle)dg);
                    continue;
                }
                if (!(dg instanceof DataGroupHandle) || (cg = this.convertGroup(factory, (DataGroupHandle)dg)) == null) continue;
                clist.add(cg);
            }
            return clist;
        }
        return Collections.emptyList();
    }

    private GroupHandle convertGroup(ElementFactory factory, DataGroupHandle dataGroup) {
        try {
            TableGroupHandle group = factory.newTableGroup();
            group.setName(dataGroup.getGroupName());
            group.setExpressionProperty("keyExpr", (Expression)dataGroup.getExpressionProperty("keyExpr").getValue());
            group.setInterval(dataGroup.getInterval());
            group.setIntervalBase(dataGroup.getIntervalBase());
            group.setIntervalRange(dataGroup.getIntervalRange());
            group.setSortDirection(dataGroup.getSortDirection());
            return group;
        }
        catch (BirtException e) {
            e.printStackTrace();
            return null;
        }
    }
}

