/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.figures;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class FixedConnectionAnchor
extends AbstractConnectionAnchor {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private int location;
    private int inset;
    private int offset;

    public FixedConnectionAnchor(IFigure owner, int location, int inset, int offset) {
        super(owner);
        this.location = location;
        this.inset = inset;
        this.offset = offset;
    }

    public Point getLocation(Point reference) {
        int y;
        int x;
        Rectangle r = this.getOwner().getBounds();
        switch (this.location) {
            case 0: {
                x = r.x + this.offset;
                y = r.y + this.inset;
                break;
            }
            case 1: {
                x = r.x + this.offset;
                y = r.bottom() - this.inset;
                break;
            }
            case 2: {
                x = r.x + this.inset;
                y = r.y + this.offset;
                break;
            }
            case 3: {
                x = r.right() - this.inset;
                y = r.y + this.offset;
                break;
            }
            default: {
                x = r.right() - r.width / 2;
                y = r.bottom() - r.height / 2;
            }
        }
        PrecisionPoint p = new PrecisionPoint(x, y);
        this.getOwner().translateToAbsolute((Translatable)p);
        return p;
    }

    public Point getReferencePoint() {
        return this.getLocation(null);
    }
}

