/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CFInfoLogger {
    private static final String CRLF = System.getProperty("line.separator");
    private final List<String> messagesToWrite = new ArrayList<String>();
    private final File logFile;
    private CFInfoLoggerThread thread;

    public CFInfoLogger(File f) {
        this.logFile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String str) {
        List<String> list = this.messagesToWrite;
        synchronized (list) {
            if (this.thread == null) {
                this.thread = new CFInfoLoggerThread(this.logFile);
                this.thread.start();
            }
            this.messagesToWrite.add(str);
            this.messagesToWrite.notify();
        }
    }

    private class CFInfoLoggerThread
    extends Thread {
        private final SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM d yyyy hh:mm:ss aaa");
        private final File f;
        private boolean threadIsRunning = true;

        public CFInfoLoggerThread(File f) {
            this.f = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList localCopy = new ArrayList();
            boolean appendLog = !this.f.exists() || this.f.length() <= 524288L;
            FileWriter fw = null;
            try {
                while (this.threadIsRunning) {
                    List list = CFInfoLogger.this.messagesToWrite;
                    synchronized (list) {
                        try {
                            while (CFInfoLogger.this.messagesToWrite.size() == 0 && this.threadIsRunning) {
                                CFInfoLogger.this.messagesToWrite.wait();
                            }
                            localCopy.addAll(CFInfoLogger.this.messagesToWrite);
                            CFInfoLogger.this.messagesToWrite.clear();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            this.threadIsRunning = false;
                        }
                    }
                    if (localCopy.size() <= 0) continue;
                    if (fw == null) {
                        fw = new FileWriter(this.f, appendLog);
                    }
                    String currTimestamp = this.sdf.format(new Date());
                    StringBuilder sb = new StringBuilder();
                    for (String msg : localCopy) {
                        sb.append(currTimestamp);
                        sb.append(" - ");
                        sb.append(msg);
                        sb.append(CRLF);
                    }
                    fw.write(sb.toString());
                    fw.flush();
                    localCopy.clear();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.threadIsRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            List list = CFInfoLogger.this.messagesToWrite;
            synchronized (list) {
                this.threadIsRunning = false;
                CFInfoLogger.this.messagesToWrite.notify();
            }
        }
    }
}

