/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExternalArchiveSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    private static final String ROOT_DIR = String.valueOf(ExternalArchiveSourceContainerBrowser.class.getName()) + ".rootDir";

    @Override
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        FileDialog dialog = new FileDialog(shell, 4098);
        String rootDir = DebugUIPlugin.getDefault().getDialogSettings().get(ROOT_DIR);
        dialog.setText(SourceLookupUIMessages.ExternalArchiveSourceContainerBrowser_2);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        if (rootDir != null) {
            dialog.setFilterPath(rootDir);
        }
        dialog.open();
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        if (nChosen > 0) {
            rootDir = dialog.getFilterPath();
            Path filterPath = new Path(rootDir);
            ISourceContainer[] containers = new ISourceContainer[nChosen];
            int i = 0;
            while (i < nChosen) {
                IPath path = filterPath.append(fileNames[i]).makeAbsolute();
                containers[i] = new ExternalArchiveSourceContainer(path.toOSString(), true);
                ++i;
            }
            DebugUIPlugin.getDefault().getDialogSettings().put(ROOT_DIR, rootDir);
            return containers;
        }
        return new ISourceContainer[0];
    }
}

