/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.IEqualityHelper;

public class ConflictMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target.getConflict() != null && target.getConflict().getKind() == ConflictKind.REAL;
    }

    @Override
    public boolean apply(IMergeCriterion criterion) {
        return criterion == null || criterion == IMergeCriterion.NONE;
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (ConflictMerger.isInTerminalState(target)) {
            return;
        }
        if (target.getSource() == DifferenceSource.LEFT) {
            Conflict conflict = target.getConflict();
            for (Diff conflictedDiff : conflict.getDifferences()) {
                if (conflictedDiff.getSource() != DifferenceSource.RIGHT) continue;
                if (this.isConflictVsMoveAndDelete(target, conflictedDiff, true)) {
                    conflictedDiff.setState(DifferenceState.DISCARDED);
                    continue;
                }
                this.mergeConflictedDiff(conflictedDiff, true, monitor);
            }
        }
        this.getMergerDelegate(target).copyLeftToRight(target, monitor);
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (ConflictMerger.isInTerminalState(target)) {
            return;
        }
        if (target.getSource() == DifferenceSource.RIGHT) {
            Conflict conflict = target.getConflict();
            for (Diff conflictedDiff : conflict.getDifferences()) {
                if (conflictedDiff.getSource() != DifferenceSource.LEFT) continue;
                if (this.isConflictVsMoveAndDelete(target, conflictedDiff, false)) {
                    conflictedDiff.setState(DifferenceState.DISCARDED);
                    continue;
                }
                this.mergeConflictedDiff(conflictedDiff, false, monitor);
            }
        }
        this.getMergerDelegate(target).copyRightToLeft(target, monitor);
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean rightToLeft) {
        Set<Diff> result = super.getDirectMergeDependencies(diff, rightToLeft);
        Conflict conflict = diff.getConflict();
        if (AbstractMerger.isAccepting(diff, rightToLeft)) {
            for (Diff conflictingDiff : conflict.getDifferences()) {
                if (conflictingDiff.getSource() == diff.getSource() || this.isConflictVsMoveAndDelete(conflictingDiff, diff, !rightToLeft) || conflictingDiff.getKind() == DifferenceKind.MOVE) continue;
                result.add(conflictingDiff);
            }
        }
        return result;
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean rightToLeft) {
        Set<Diff> result = super.getDirectResultingMerges(diff, rightToLeft);
        Conflict conflict = diff.getConflict();
        if (AbstractMerger.isAccepting(diff, rightToLeft)) {
            for (Diff conflictingDiff : conflict.getDifferences()) {
                if (conflictingDiff.getSource() == diff.getSource() || !this.isConflictVsMoveAndDelete(conflictingDiff, diff, !rightToLeft) && conflictingDiff.getKind() == DifferenceKind.MOVE) continue;
                result.add(conflictingDiff);
            }
        }
        return result;
    }

    private boolean isConflictVsMoveAndDelete(Diff target, Diff conflictedDiff, boolean leftToRight) {
        boolean result = false;
        if (target.getConflict() != null && target.getConflict().getKind() == ConflictKind.REAL && target instanceof ReferenceChange && target.getKind() == DifferenceKind.MOVE) {
            ReferenceChange moveDiff = (ReferenceChange)target;
            if (conflictedDiff instanceof ReferenceChange && conflictedDiff.getKind() == DifferenceKind.DELETE) {
                ReferenceChange deleteDiff = (ReferenceChange)conflictedDiff;
                IEqualityHelper equalityHelper = target.getMatch().getComparison().getEqualityHelper();
                result = equalityHelper.matchingAttributeValues(moveDiff.getValue(), deleteDiff.getValue());
            }
        }
        return result;
    }

    private void mergeConflictedDiff(Diff conflictedDiff, boolean leftToRight, Monitor monitor) {
        if (conflictedDiff.getKind() != DifferenceKind.MOVE) {
            DelegatingMerger delegate = this.getMergerDelegate(conflictedDiff);
            if (leftToRight) {
                delegate.copyLeftToRight(conflictedDiff, monitor);
            } else {
                delegate.copyRightToLeft(conflictedDiff, monitor);
            }
        } else {
            conflictedDiff.setState(DifferenceState.DISCARDED);
        }
    }

    @Override
    protected DelegatingMerger getMergerDelegate(Diff diff) {
        IMergeCriterion criterion = (IMergeCriterion)this.getMergeOptions().get("merge.criterion");
        Iterator<IMerger> it = ((IMerger.Registry2)this.getRegistry()).getMergersByRankDescending(diff, criterion);
        IMerger merger = this;
        while (it.hasNext() && merger == this) {
            merger = it.next();
        }
        if (merger == null) {
            throw new IllegalStateException("No merger found for diff " + diff.getClass().getSimpleName());
        }
        return new DelegatingMerger(merger, criterion);
    }
}

