/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.impl;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IConfigurationElement;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;

import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;

import org.eclipse.swt.graphics.Image;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Processor Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getProcessor <em>Processor</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getConfigurationElement <em>Configuration Element</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getIcon16 <em>Icon16</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getContributor <em>Contributor</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getDirective <em>Directive</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl#isAutomatic <em>Automatic</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProcessorDescriptorImpl extends MinimalEObjectImpl.Container implements IProcessorDescriptor {
	/**
	 * The default value of the '{@link #getProcessor() <em>Processor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessor()
	 * @generated
	 * @ordered
	 */
	protected static final ReportProcessorSafeWrapper PROCESSOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProcessor() <em>Processor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessor()
	 * @generated
	 * @ordered
	 */
	protected ReportProcessorSafeWrapper processor = PROCESSOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getConfigurationElement() <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigurationElement()
	 * @generated
	 * @ordered
	 */
	protected static final IConfigurationElement CONFIGURATION_ELEMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getConfigurationElement() <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigurationElement()
	 * @generated
	 * @ordered
	 */
	protected IConfigurationElement configurationElement = CONFIGURATION_ELEMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getIcon16() <em>Icon16</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon16()
	 * @generated
	 * @ordered
	 */
	protected static final String ICON16_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIcon16() <em>Icon16</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon16()
	 * @generated
	 * @ordered
	 */
	protected String icon16 = ICON16_EDEFAULT;

	/**
	 * The default value of the '{@link #getContributor() <em>Contributor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContributor()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTRIBUTOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContributor() <em>Contributor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContributor()
	 * @generated
	 * @ordered
	 */
	protected String contributor = CONTRIBUTOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getDirective() <em>Directive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDirective()
	 * @generated
	 * @ordered
	 */
	protected static final String DIRECTIVE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDirective() <em>Directive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDirective()
	 * @generated
	 * @ordered
	 */
	protected String directive = DIRECTIVE_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isAutomatic() <em>Automatic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAutomatic()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUTOMATIC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAutomatic() <em>Automatic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAutomatic()
	 * @generated
	 * @ordered
	 */
	protected boolean automatic = AUTOMATIC_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IIdePackage.Literals.PROCESSOR_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReportProcessorSafeWrapper getProcessor() {
		return processor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessor(ReportProcessorSafeWrapper newProcessor) {
		ReportProcessorSafeWrapper oldProcessor = processor;
		processor = newProcessor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__PROCESSOR, oldProcessor, processor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IConfigurationElement getConfigurationElement() {
		return configurationElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
		IConfigurationElement oldConfigurationElement = configurationElement;
		configurationElement = newConfigurationElement;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT, oldConfigurationElement, configurationElement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIcon16() {
		return icon16;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIcon16(String newIcon16) {
		String oldIcon16 = icon16;
		icon16 = newIcon16;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__ICON16, oldIcon16, icon16));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContributor() {
		return contributor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContributor(String newContributor) {
		String oldContributor = contributor;
		contributor = newContributor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__CONTRIBUTOR, oldContributor, contributor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDirective() {
		return directive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDirective(String newDirective) {
		String oldDirective = directive;
		directive = newDirective;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__DIRECTIVE, oldDirective, directive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAutomatic() {
		return automatic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAutomatic(boolean newAutomatic) {
		boolean oldAutomatic = automatic;
		automatic = newAutomatic;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.PROCESSOR_DESCRIPTOR__AUTOMATIC, oldAutomatic, automatic));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Image getImage16() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IIdePackage.PROCESSOR_DESCRIPTOR__PROCESSOR:
				return getProcessor();
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT:
				return getConfigurationElement();
			case IIdePackage.PROCESSOR_DESCRIPTOR__DESCRIPTION:
				return getDescription();
			case IIdePackage.PROCESSOR_DESCRIPTOR__ICON16:
				return getIcon16();
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONTRIBUTOR:
				return getContributor();
			case IIdePackage.PROCESSOR_DESCRIPTOR__DIRECTIVE:
				return getDirective();
			case IIdePackage.PROCESSOR_DESCRIPTOR__NAME:
				return getName();
			case IIdePackage.PROCESSOR_DESCRIPTOR__AUTOMATIC:
				return isAutomatic();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IIdePackage.PROCESSOR_DESCRIPTOR__PROCESSOR:
				setProcessor((ReportProcessorSafeWrapper)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT:
				setConfigurationElement((IConfigurationElement)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__ICON16:
				setIcon16((String)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONTRIBUTOR:
				setContributor((String)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__DIRECTIVE:
				setDirective((String)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__NAME:
				setName((String)newValue);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__AUTOMATIC:
				setAutomatic((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IIdePackage.PROCESSOR_DESCRIPTOR__PROCESSOR:
				setProcessor(PROCESSOR_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT:
				setConfigurationElement(CONFIGURATION_ELEMENT_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__ICON16:
				setIcon16(ICON16_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONTRIBUTOR:
				setContributor(CONTRIBUTOR_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__DIRECTIVE:
				setDirective(DIRECTIVE_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__NAME:
				setName(NAME_EDEFAULT);
				return;
			case IIdePackage.PROCESSOR_DESCRIPTOR__AUTOMATIC:
				setAutomatic(AUTOMATIC_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IIdePackage.PROCESSOR_DESCRIPTOR__PROCESSOR:
				return PROCESSOR_EDEFAULT == null ? processor != null : !PROCESSOR_EDEFAULT.equals(processor);
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT:
				return CONFIGURATION_ELEMENT_EDEFAULT == null ? configurationElement != null : !CONFIGURATION_ELEMENT_EDEFAULT.equals(configurationElement);
			case IIdePackage.PROCESSOR_DESCRIPTOR__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case IIdePackage.PROCESSOR_DESCRIPTOR__ICON16:
				return ICON16_EDEFAULT == null ? icon16 != null : !ICON16_EDEFAULT.equals(icon16);
			case IIdePackage.PROCESSOR_DESCRIPTOR__CONTRIBUTOR:
				return CONTRIBUTOR_EDEFAULT == null ? contributor != null : !CONTRIBUTOR_EDEFAULT.equals(contributor);
			case IIdePackage.PROCESSOR_DESCRIPTOR__DIRECTIVE:
				return DIRECTIVE_EDEFAULT == null ? directive != null : !DIRECTIVE_EDEFAULT.equals(directive);
			case IIdePackage.PROCESSOR_DESCRIPTOR__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case IIdePackage.PROCESSOR_DESCRIPTOR__AUTOMATIC:
				return automatic != AUTOMATIC_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case IIdePackage.PROCESSOR_DESCRIPTOR___GET_IMAGE16:
				return getImage16();
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (processor: ");
		result.append(processor);
		result.append(", configurationElement: ");
		result.append(configurationElement);
		result.append(", description: ");
		result.append(description);
		result.append(", icon16: ");
		result.append(icon16);
		result.append(", contributor: ");
		result.append(contributor);
		result.append(", directive: ");
		result.append(directive);
		result.append(", name: ");
		result.append(name);
		result.append(", automatic: ");
		result.append(automatic);
		result.append(')');
		return result.toString();
	}

} //ProcessorDescriptorImpl
