/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin.dialogs;

import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.IUGroup;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IUProfilePropertiesGroup
extends IUGroup {
    private Table propertiesTable;

    public IUProfilePropertiesGroup(Composite parent, InstalledIUElement iuElement, ModifyListener listener) {
        super(parent, iuElement, listener);
    }

    protected Composite createGroupComposite(Composite parent, ModifyListener listener) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 400;
        composite.setLayoutData((Object)data);
        this.propertiesTable = new Table(composite, 2816);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.propertiesTable.setLayoutData((Object)data);
        this.propertiesTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.propertiesTable, 0);
        nameColumn.setResizable(true);
        nameColumn.setWidth(200);
        TableColumn valueColumn = new TableColumn(this.propertiesTable, 0);
        valueColumn.setResizable(true);
        valueColumn.setWidth(250);
        this.initializeFields();
        return composite;
    }

    private void initializeFields() {
        if (this.iuElement == null || !(this.iuElement instanceof InstalledIUElement)) {
            return;
        }
        String[] propNames = new String[]{"org.eclipse.equinox.p2.type.root"};
        String[] userPropNames = new String[]{ProvAdminUIMessages.ProfileRootPropertyName};
        int i = 0;
        while (i < propNames.length) {
            String value;
            TableItem item = new TableItem(this.propertiesTable, 0);
            IProfile profile = this.getProfile((InstalledIUElement)this.iuElement);
            String string = value = profile == null ? null : profile.getInstallableUnitProperty(this.getIU(), propNames[i]);
            if (value != null) {
                item.setText(new String[]{userPropNames[i], value});
            }
            ++i;
        }
    }

    private IProfile getProfile(InstalledIUElement element) {
        return ProvAdminUIActivator.getDefault().getProfileRegistry().getProfile(element.getProfileId());
    }
}

