/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng.internal;

import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext_ng.internal.BaseStyledLineRenderer;

public class SingleTextGradientStyledLineRenderer
extends BaseStyledLineRenderer {
    private final LayoutPane node = new LayoutPane();

    @Override
    public void setVisibleRange(double minX, double width) {
    }

    @Override
    public void clearStyles() {
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    protected void rebuildFill() {
        this.rebuildText();
    }

    @Override
    protected void rebuildFonts() {
        this.rebuildText();
    }

    @Override
    protected void rebuildText() {
        if (this.combinedAction) {
            this.flag |= 4;
            return;
        }
        this.node.requestLayout();
    }

    void refreshLayout() {
        Text tNode;
        if (this.flag == 0) {
            return;
        }
        this.flag = 0;
        RangeSet<Integer> normalFont = this.getNormalRange();
        RangeSet<Integer> boldRange = this.getBoldRange();
        RangeSet<Integer> italicRange = this.getItalicRange();
        RangeSet<Integer> boldItalicRange = this.getBoldItalicRange();
        List<BaseStyledLineRenderer.PaintRange> pr = this.getPaintRanges();
        pr = pr.stream().sorted((r1, r2) -> ((Integer)r1.range.lowerEndpoint()).compareTo((Integer)r2.range.lowerEndpoint())).collect(Collectors.toList());
        double charWidth = Util.getSize((Font)this.normal, (char)' ').width;
        double w = charWidth * (double)this.displayedText.length;
        ArrayList<Stop> stops = new ArrayList<Stop>(pr.size() * 2);
        for (BaseStyledLineRenderer.PaintRange r : pr) {
            Stop start = new Stop((double)((Integer)r.range.lowerEndpoint()).intValue() * charWidth / w, (Color)r.paint);
            Stop end = new Stop((double)((Integer)r.range.upperEndpoint() + 1) * charWidth / w, (Color)r.paint);
            stops.add(start);
            stops.add(end);
        }
        LinearGradient lg = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
        System.err.println(lg);
        ArrayList<Text> nodes = new ArrayList<Text>(4);
        if (!normalFont.isEmpty()) {
            tNode = SingleTextGradientStyledLineRenderer.createTextNode(normalFont, this.originalText, this.tabReplace, this.normal);
            tNode.setFill((Paint)lg);
            nodes.add(tNode);
        }
        if (!boldRange.isEmpty()) {
            tNode = SingleTextGradientStyledLineRenderer.createTextNode(boldRange, this.originalText, this.tabReplace, this.bold);
            tNode.setFill((Paint)lg);
            nodes.add(tNode);
        }
        if (!italicRange.isEmpty()) {
            tNode = SingleTextGradientStyledLineRenderer.createTextNode(italicRange, this.originalText, this.tabReplace, this.italic);
            tNode.setFill((Paint)lg);
            nodes.add(tNode);
        }
        if (!boldItalicRange.isEmpty()) {
            tNode = SingleTextGradientStyledLineRenderer.createTextNode(boldItalicRange, this.originalText, this.tabReplace, this.boldItalic);
            tNode.setFill((Paint)lg);
            nodes.add(tNode);
        }
        this.node.getChildren().setAll(nodes);
    }

    private static Text createTextNode(RangeSet<Integer> rangeSet, char[] text, char[] tabReplace, Font font) {
        char[] txt = TextUtil.replace((char[])text, (char)' ', (idx, ch) -> ch != 9 && !rangeSet.contains((Comparable)Integer.valueOf(idx)));
        Text tNode = new Text(String.valueOf(TextUtil.replaceAll((char[])txt, (char)'\r', (char[])tabReplace)));
        tNode.setFont(font);
        return tNode;
    }

    class LayoutPane
    extends Region {
        LayoutPane() {
        }

        protected void layoutChildren() {
            SingleTextGradientStyledLineRenderer.this.refreshLayout();
            this.getChildren().forEach(c -> c.resizeRelocate(0.0, 0.0, c.prefWidth(-1.0), c.prefHeight(-1.0)));
        }

        public ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        protected double computeMinHeight(double width) {
            return Util.getSize((Font)SingleTextGradientStyledLineRenderer.this.normal, (char)' ').height;
        }

        protected double computePrefHeight(double width) {
            return super.computeMinHeight(width);
        }

        protected double computeMaxHeight(double width) {
            return super.computeMinHeight(width);
        }

        protected double computeMinWidth(double height) {
            return Util.getSize((Font)SingleTextGradientStyledLineRenderer.this.normal, (char)' ').width * (double)SingleTextGradientStyledLineRenderer.this.displayedText.length;
        }

        protected double computePrefWidth(double height) {
            return super.computeMinWidth(height);
        }

        protected double computeMaxWidth(double height) {
            return super.computeMinWidth(height);
        }
    }
}

