/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.AmazonS3;
import org.kohsuke.args4j.Argument;

@Command(name="amazon-s3-client", common=false, usage="usage_CommandLineClientForamazonsS3Service")
class AmazonS3Client
extends TextBuiltin {
    @Argument(index=0, metaVar="metaVar_connProp", required=true)
    private File propertyFile;
    @Argument(index=1, metaVar="metaVar_op", required=true)
    private String op;
    @Argument(index=2, metaVar="metaVar_bucket", required=true)
    private String bucket;
    @Argument(index=3, metaVar="metaVar_KEY", required=true)
    private String key;

    AmazonS3Client() {
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Exception {
        AmazonS3 s3 = new AmazonS3(this.properties());
        if ("get".equals(this.op)) {
            URLConnection c = s3.get(this.bucket, this.key);
            try (InputStream in = c.getInputStream();){
                int n;
                this.outw.flush();
                byte[] tmp = new byte[2048];
                for (int len = c.getContentLength(); len > 0; len -= n) {
                    n = in.read(tmp);
                    if (n < 0) {
                        throw new EOFException(MessageFormat.format(CLIText.get().expectedNumberOfbytes, len));
                    }
                    this.outs.write(tmp, 0, n);
                }
                this.outs.flush();
            }
        } else if ("ls".equals(this.op) || "list".equals(this.op)) {
            for (String k : s3.list(this.bucket, this.key)) {
                this.outw.println(k);
            }
        } else if ("rm".equals(this.op) || "delete".equals(this.op)) {
            s3.delete(this.bucket, this.key);
        } else if ("put".equals(this.op)) {
            int n;
            OutputStream os = s3.beginPut(this.bucket, this.key, null, null);
            byte[] tmp = new byte[2048];
            while ((n = this.ins.read(tmp)) > 0) {
                os.write(tmp, 0, n);
            }
            os.close();
        } else {
            throw AmazonS3Client.die(MessageFormat.format(CLIText.get().unsupportedOperation, this.op));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties properties() {
        Properties properties;
        FileInputStream in = new FileInputStream(this.propertyFile);
        try {
            Properties p = new Properties();
            p.load(in);
            properties = p;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw AmazonS3Client.die(MessageFormat.format(CLIText.get().noSuchFile, this.propertyFile), (Throwable)e);
            }
            catch (IOException e) {
                throw AmazonS3Client.die(MessageFormat.format(CLIText.get().cannotReadBecause, this.propertyFile, e.getMessage()), (Throwable)e);
            }
        }
        ((InputStream)in).close();
        return properties;
    }
}

