/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.examples.wizards;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

class ImageCanvas
extends Canvas {
    private Image fImage;

    public ImageCanvas(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200);
        ScrollBar sb = this.getHorizontalBar();
        sb.setIncrement(20);
        sb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ImageCanvas.this.repaint();
            }
        });
        sb = this.getVerticalBar();
        sb.setIncrement(20);
        sb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ImageCanvas.this.repaint();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ImageCanvas.this.updateScrollbars();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ImageCanvas.this.paint(event.gc);
            }
        });
    }

    public void setImage(Image img) {
        this.fImage = img;
        if (!this.isDisposed()) {
            this.getHorizontalBar().setSelection(0);
            this.getVerticalBar().setSelection(0);
            this.updateScrollbars();
            this.getParent().layout();
            this.redraw();
        }
    }

    public void repaint() {
        if (!this.isDisposed()) {
            GC gc = new GC((Drawable)this);
            this.paint(gc);
            gc.dispose();
        }
    }

    void paint(GC gc) {
        if (this.fImage != null) {
            Rectangle bounds = this.fImage.getBounds();
            Rectangle clientArea = this.getClientArea();
            int x = bounds.width < clientArea.width ? (clientArea.width - bounds.width) / 2 : -this.getHorizontalBar().getSelection();
            int y = bounds.height < clientArea.height ? (clientArea.height - bounds.height) / 2 : -this.getVerticalBar().getSelection();
            gc.drawImage(this.fImage, x, y);
        }
    }

    void updateScrollbars() {
        Rectangle bounds = this.fImage != null ? this.fImage.getBounds() : new Rectangle(0, 0, 0, 0);
        Point size = this.getSize();
        Rectangle clientArea = this.getClientArea();
        ScrollBar horizontal = this.getHorizontalBar();
        if (bounds.width <= clientArea.width) {
            horizontal.setVisible(false);
            horizontal.setSelection(0);
        } else {
            horizontal.setPageIncrement(clientArea.width - horizontal.getIncrement());
            int max = bounds.width + (size.x - clientArea.width);
            horizontal.setMaximum(max);
            horizontal.setThumb(size.x > max ? max : size.x);
            horizontal.setVisible(true);
        }
        ScrollBar vertical = this.getVerticalBar();
        if (bounds.height <= clientArea.height) {
            vertical.setVisible(false);
            vertical.setSelection(0);
        } else {
            vertical.setPageIncrement(clientArea.height - vertical.getIncrement());
            int max = bounds.height + (size.y - clientArea.height);
            vertical.setMaximum(max);
            vertical.setThumb(size.y > max ? max : size.y);
            vertical.setVisible(true);
        }
    }
}

