/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.interpreter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ldt.debug.core.internal.model.interpreter.Info;
import org.eclipse.ldt.debug.core.internal.model.interpreter.InterpreterPackage;
import org.eclipse.ldt.debug.core.interpreter.ILuaInterpreterInstallType;

public final class LuaInterpreterUtil {
    private LuaInterpreterUtil() {
    }

    public static IInterpreterInstall getDefaultInterpreter() {
        return ScriptRuntime.getDefaultInterpreterInstall((String)"org.eclipse.ldt.nature", null);
    }

    public static List<IInterpreterInstall> getInterpreters() {
        ArrayList<IInterpreterInstall> interpreters = new ArrayList<IInterpreterInstall>();
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)"org.eclipse.ldt.nature");
        int i = 0;
        while (i < types.length) {
            IInterpreterInstallType type = types[i];
            IInterpreterInstall[] installs = type.getInterpreterInstalls();
            if (installs != null) {
                int j = 0;
                while (j < installs.length) {
                    IInterpreterInstall install = installs[j];
                    interpreters.add(install);
                    ++j;
                }
            }
            ++i;
        }
        return interpreters;
    }

    public static boolean isEmbedded(IInterpreterInstall interpreter) {
        IInterpreterInstallType interpreterInstallType = interpreter.getInterpreterInstallType();
        return interpreterInstallType instanceof ILuaInterpreterInstallType && ((ILuaInterpreterInstallType)interpreterInstallType).isEmbeddedInterpreter();
    }

    public static boolean interpreterHandlesExecuteOption(IInterpreterInstall interpreter) {
        Info info;
        if (interpreter != null && (info = LuaInterpreterUtil.getInfoFromInterpreter(interpreter)) != null) {
            return info.isExecuteOptionCapable();
        }
        return (Boolean)InterpreterPackage.eINSTANCE.getInfo_ExecuteOptionCapable().getDefaultValue();
    }

    public static boolean interpreterHandlesFilesAsArgument(IInterpreterInstall interpreter) {
        Info info;
        if (interpreter != null && (info = LuaInterpreterUtil.getInfoFromInterpreter(interpreter)) != null) {
            return info.isFileAsArgumentsCapable();
        }
        return (Boolean)InterpreterPackage.eINSTANCE.getInfo_FileAsArgumentsCapable().getDefaultValue();
    }

    public static String linkedExecutionEnvironmentName(IInterpreterInstall interpreter) {
        if (interpreter != null) {
            Info info = LuaInterpreterUtil.getInfoFromInterpreter(interpreter);
            if (info != null) {
                return info.getLinkedExecutionEnvironmentName();
            }
            IInterpreterInstallType interpreterInstallType = interpreter.getInterpreterInstallType();
            if (interpreterInstallType instanceof ILuaInterpreterInstallType) {
                return ((ILuaInterpreterInstallType)interpreterInstallType).getDefaultEEName();
            }
        }
        return null;
    }

    public static String linkedExecutionEnvironmentVersion(IInterpreterInstall interpreter) {
        if (interpreter != null) {
            Info info = LuaInterpreterUtil.getInfoFromInterpreter(interpreter);
            if (info != null) {
                return info.getLinkedExecutionEnvironmentVersion();
            }
            IInterpreterInstallType interpreterInstallType = interpreter.getInterpreterInstallType();
            if (interpreterInstallType instanceof ILuaInterpreterInstallType) {
                return ((ILuaInterpreterInstallType)interpreterInstallType).getDefaultEEVersion();
            }
        }
        return null;
    }

    public static boolean isExecutionEnvironmentCompatible(IInterpreterInstall interpreter, String eeName, String eeVersion) {
        String linkedEEName = LuaInterpreterUtil.linkedExecutionEnvironmentName(interpreter);
        String linkedEEVersion = LuaInterpreterUtil.linkedExecutionEnvironmentVersion(interpreter);
        return linkedEEName != null && linkedEEVersion != null && linkedEEName.equals(eeName) && linkedEEVersion.equals(eeVersion);
    }

    private static Info getInfoFromInterpreter(IInterpreterInstall interpreter) {
        for (EObject extension : interpreter.getExtensions()) {
            if (!(extension instanceof Info)) continue;
            return (Info)extension;
        }
        return null;
    }
}

