/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.operations.diagnostics.LSPDiagnosticsToMarkers;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageClientImpl
implements LanguageClient {
    private LSPDiagnosticsToMarkers diagnosticHandler;
    private LanguageServer server;
    private ProjectSpecificLanguageServerWrapper wrapper;

    public final void connect(LanguageServer server, ProjectSpecificLanguageServerWrapper wrapper) {
        this.server = server;
        this.wrapper = wrapper;
        this.diagnosticHandler = new LSPDiagnosticsToMarkers(wrapper.project, wrapper.serverDefinition.id);
    }

    protected final LanguageServer getLanguageServer() {
        return this.server;
    }

    public void telemetryEvent(Object object) {
    }

    public final CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return ServerMessageHandler.showMessageRequest(requestParams);
    }

    public final void showMessage(MessageParams messageParams) {
        ServerMessageHandler.showMessage(messageParams);
    }

    public final void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.diagnosticHandler.accept(diagnostics);
    }

    public final void logMessage(MessageParams message) {
        ServerMessageHandler.logMessage(this.wrapper.project, this.wrapper.serverDefinition.label, message);
    }

    public final CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(final ApplyWorkspaceEditParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Job job = new Job(Messages.serverEdit){

                public IStatus run(IProgressMonitor monitor) {
                    LSPEclipseUtils.applyWorkspaceEdit(params.getEdit());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
                return new ApplyWorkspaceEditResponse(Boolean.valueOf(true));
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                return new ApplyWorkspaceEditResponse(Boolean.FALSE);
            }
        });
    }
}

