/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;
import org.eclipse.lsp4e.operations.codeactions.CodeActionMarkerResolution;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.progress.ProgressInfoItem;

public class LSPCodeActionMarkerResolution
implements IMarkerResolutionGenerator2 {
    private static final String LSP_REMEDIATION = "lspCodeActions";
    private static final IMarkerResolution2 COMPUTING = new IMarkerResolution2(){

        public void run(IMarker marker) {
        }

        public String getLabel() {
            return Messages.computing;
        }

        public Image getImage() {
            return JFaceResources.getImage((String)(String.valueOf(ProgressInfoItem.class.getPackage().getName()) + ".PROGRESS_DEFAULT"));
        }

        public String getDescription() {
            return Messages.computing;
        }
    };

    public IMarkerResolution[] getResolutions(IMarker marker) {
        Object att;
        try {
            this.checkMarkerResoultion(marker);
            att = marker.getAttribute(LSP_REMEDIATION);
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
            return new IMarkerResolution[0];
        }
        if (att == COMPUTING) {
            return new IMarkerResolution[]{COMPUTING};
        }
        List commands = (List)att;
        if (commands == null) {
            return new CodeActionMarkerResolution[0];
        }
        ArrayList<CodeActionMarkerResolution> res = new ArrayList<CodeActionMarkerResolution>(commands.size());
        for (Command command : commands) {
            if (command == null) continue;
            res.add(new CodeActionMarkerResolution(command));
        }
        return res.toArray(new IMarkerResolution[res.size()]);
    }

    private void checkMarkerResoultion(IMarker marker) throws Exception {
        if (marker.getAttribute(LSP_REMEDIATION) != null) {
            return;
        }
        IResource res = marker.getResource();
        if (res != null && res.getType() == 1) {
            ServerCapabilities capabilites;
            ProjectSpecificLanguageServerWrapper wrapper;
            LanguageServersRegistry.LanguageServerDefinition definition;
            IFile file = (IFile)res;
            String languageServerId = marker.getAttribute("languageServerId", null);
            ArrayList<LanguageServer> languageServers = new ArrayList<LanguageServer>();
            if (languageServerId != null && (definition = LanguageServersRegistry.getInstance().getDefinition(languageServerId)) != null && (wrapper = LanguageServiceAccessor.getLSWrapperForConnection(file.getProject(), definition)) != null && ((capabilites = wrapper.getServerCapabilities()) == null || Boolean.TRUE.equals(capabilites.getCodeActionProvider()))) {
                languageServers.add(wrapper.getServer());
            }
            if (languageServers.isEmpty()) {
                languageServers.addAll(LanguageServiceAccessor.getLanguageServers(file, capabilities -> Boolean.TRUE.equals(capabilities.getCodeActionProvider())));
            }
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (LanguageServer ls : languageServers) {
                marker.setAttribute(LSP_REMEDIATION, (Object)COMPUTING);
                Diagnostic diagnostic = (Diagnostic)marker.getAttribute("lspDiagnostic");
                CodeActionContext context = new CodeActionContext(Collections.singletonList(diagnostic));
                CodeActionParams params = new CodeActionParams();
                params.setContext(context);
                params.setTextDocument(new TextDocumentIdentifier(LSPEclipseUtils.toUri(marker.getResource()).toString()));
                params.setRange(diagnostic.getRange());
                CompletableFuture codeAction = ls.getTextDocumentService().codeAction(params);
                futures.add(codeAction);
                codeAction.thenAccept(actions -> {
                    try {
                        marker.setAttribute(LSP_REMEDIATION, actions);
                    }
                    catch (CoreException e) {
                        LanguageServerPlugin.logError(e);
                    }
                });
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).get(300L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean hasResolutions(IMarker marker) {
        try {
            this.checkMarkerResoultion(marker);
            Object remediation = marker.getAttribute(LSP_REMEDIATION);
            return remediation == COMPUTING || remediation instanceof Collection && !((Collection)remediation).isEmpty();
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            return false;
        }
    }
}

