/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.QueueInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.ParserPlugin;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;

public class ObjectMarker {
    int[] roots;
    boolean[] bits;
    IIndexReader.IOne2ManyIndex outbound;
    long outboundMem;
    IProgressListener progressListener;
    private static final boolean DEBUG = Platform.inDebugMode() && ParserPlugin.getDefault().isDebugging();
    private static final boolean USELOCAL = !Platform.inDebugMode() || !ParserPlugin.getDefault().isDebugging() || !Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.parser/debug/oldMarker"));
    private static final int MIN_LOCALITY = 1000000;

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, IProgressListener progressListener) {
        this(roots, bits, outbound, 0L, progressListener);
    }

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, long outboundLength, IProgressListener progressListener) {
        this.roots = roots;
        this.bits = bits;
        this.outbound = outbound;
        this.outboundMem = outboundLength > 0L ? outboundLength : (long)outbound.size() * 30L;
        this.progressListener = progressListener;
    }

    public int markSingleThreaded() throws IProgressListener.OperationCanceledException {
        int count = 0;
        int size = 0;
        int[] data = new int[10240];
        int rootsToProcess = 0;
        int[] nArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            int rootId = nArray[n2];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n2;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsToProcess);
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            int[] nArray2 = this.outbound.get(current);
            int n3 = nArray2.length;
            n = 0;
            while (n < n3) {
                int child = nArray2[n];
                if (!this.bits[child]) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    ++count;
                }
                ++n;
            }
        }
        this.progressListener.done();
        return count;
    }

    public int markSingleThreaded(ExcludedReferencesDescriptor[] excludeSets, ISnapshot snapshot) throws SnapshotException, IProgressListener.OperationCanceledException {
        int n;
        int n2;
        int[] nArray;
        BitField excludeObjectsBF = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ExcludedReferencesDescriptor[] excludedReferencesDescriptorArray = excludeSets;
        int n3 = excludeSets.length;
        int n4 = 0;
        while (n4 < n3) {
            ExcludedReferencesDescriptor set = excludedReferencesDescriptorArray[n4];
            nArray = set.getObjectIds();
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int k = nArray[n];
                excludeObjectsBF.set(k);
                ++n;
            }
            ++n4;
        }
        int count = 0;
        int rootsToProcess = 0;
        int size = 0;
        int[] data = new int[10240];
        nArray = this.roots;
        n2 = this.roots.length;
        n = 0;
        while (n < n2) {
            int rootId = nArray[n];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsToProcess);
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            int[] nArray2 = this.outbound.get(current);
            int n5 = nArray2.length;
            n2 = 0;
            while (n2 < n5) {
                int child = nArray2[n2];
                if (!this.bits[child] && !this.refersOnlyThroughExcluded(current, child, excludeSets, excludeObjectsBF, snapshot)) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    ++count;
                }
                ++n2;
            }
        }
        this.progressListener.done();
        return count;
    }

    public void markMultiThreaded(int numberOfThreads) throws InterruptedException {
        MultiThreadedRootStack rootsStack = new MultiThreadedRootStack(this.roots.length);
        int[] nArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            int rootId = nArray[n2];
            if (!this.bits[rootId]) {
                rootsStack.push(rootId);
                this.bits[rootId] = true;
            }
            ++n2;
        }
        long l = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Starting threads " + new Date());
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsStack.size());
        int n3 = this.bits.length;
        Runtime runtime = Runtime.getRuntime();
        long maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        if (maxFree < this.outboundMem) {
            runtime.gc();
            maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        }
        int n1 = (int)Math.min((long)this.bits.length, (long)this.bits.length * maxFree / this.outboundMem);
        int m = (int)((1.0 - Math.pow((double)(n3 - n1) / (double)n3, 1.0 / (double)numberOfThreads)) * (double)n3);
        int locality = Math.min(n3, Math.max(1000000, m));
        if (DEBUG) {
            System.out.println("maxFree=" + maxFree + " outbound mem=" + this.outboundMem + " n=" + n3 + " n1=" + n1 + " m=" + m + " locality=" + locality);
        }
        DfsThread[] dfsthreads = new DfsThread[numberOfThreads];
        Thread[] threads = new Thread[numberOfThreads];
        int i = 0;
        while (i < numberOfThreads) {
            DfsThread dfsthread = USELOCAL ? new LocalDfsThread(rootsStack, locality) : new DfsThread(rootsStack);
            dfsthreads[i] = dfsthread;
            Thread thread = new Thread((Runnable)dfsthread, "ObjectMarkerThread-" + (i + 1));
            thread.start();
            threads[i] = thread;
            ++i;
        }
        i = 0;
        while (i < numberOfThreads) {
            threads[i].join();
            ++i;
        }
        if (this.progressListener.isCanceled()) {
            return;
        }
        this.progressListener.done();
        if (DEBUG) {
            System.out.println("Took " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    private boolean refersOnlyThroughExcluded(int referrerId, int referentId, ExcludedReferencesDescriptor[] excludeSets, BitField excludeObjectsBF, ISnapshot snapshot) throws SnapshotException {
        if (!excludeObjectsBF.get(referrerId)) {
            return false;
        }
        IObject referrerObject = snapshot.getObject(referrerId);
        Set excludeFields = null;
        ExcludedReferencesDescriptor[] excludedReferencesDescriptorArray = excludeSets;
        int n = excludeSets.length;
        int n2 = 0;
        while (n2 < n) {
            ExcludedReferencesDescriptor set = excludedReferencesDescriptorArray[n2];
            if (set.contains(referrerId)) {
                excludeFields = set.getFields();
                break;
            }
            ++n2;
        }
        if (excludeFields == null) {
            return true;
        }
        long referentAddr = snapshot.mapIdToAddress(referentId);
        List refs = referrerObject.getOutboundReferences();
        for (NamedReference reference : refs) {
            if (referentAddr != reference.getObjectAddress() || excludeFields.contains(reference.getName())) continue;
            return false;
        }
        return true;
    }

    public class DfsThread
    implements Runnable {
        int size = 0;
        int[] data = new int[10240];
        IntStack rootsStack;

        public DfsThread(IntStack roots) {
            this.rootsStack = roots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                var1_1 = this.rootsStack;
                synchronized (var1_1) {
                    ObjectMarker.this.progressListener.worked(1);
                    if (ObjectMarker.this.progressListener.isCanceled()) {
                        return;
                    }
                    if (this.rootsStack.size() <= 0) {
                        break;
                    }
                    this.data[0] = this.rootsStack.pop();
                    this.size = 1;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl32
                }
                do {
                    current = this.data[--this.size];
                    var5_6 = ObjectMarker.this.outbound.get(current);
                    var4_5 = var5_6.length;
                    var3_4 = 0;
                    while (var3_4 < var4_5) {
                        child = var5_6[var3_4];
                        if (!ObjectMarker.this.bits[child]) {
                            ObjectMarker.this.bits[child] = true;
                            if (this.size == this.data.length) {
                                newArr = new int[this.data.length << 1];
                                System.arraycopy(this.data, 0, newArr, 0, this.data.length);
                                this.data = newArr;
                            }
                            this.data[this.size++] = child;
                        }
                        ++var3_4;
                    }
lbl32:
                    // 2 sources

                } while (this.size > 0);
            }
        }
    }

    public class LocalDfsThread
    extends DfsThread {
        private static final int RESERVED = 15;
        static final int MAXSTACK = 102400;
        int localRange;
        final int localRangeLimit;
        SoftReference<int[]> sr;
        double scaleUp;
        MultiThreadedRootStack rootsStack;
        QueueInt queue;
        int localBase;

        public LocalDfsThread(MultiThreadedRootStack roots) {
            this(roots, 1000000);
        }

        public LocalDfsThread(MultiThreadedRootStack roots, int range) {
            super(roots);
            this.scaleUp = 0.005;
            this.queue = new QueueInt(1024);
            this.rootsStack = roots;
            this.localRange = this.localRangeLimit = range;
        }

        void initLocalStack(int val) {
            this.data[0] = val;
            this.size = 1;
            this.localBase = this.calcBase(this.data[0]);
        }

        void fillStack() {
            int originalQueueSize = this.queue.size();
            int i = 0;
            while (i < originalQueueSize) {
                int z = this.queue.get();
                if (this.inRange(z)) {
                    this.data[this.size++] = z;
                    if (this.size == this.data.length) {
                        break;
                    }
                } else {
                    this.queue.put(z);
                }
                ++i;
            }
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 15[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean inRange(int val) {
            return val >= this.localBase && val - this.localBase < this.localRange;
        }

        private int calcBase(int v) {
            this.calcRange();
            return Math.max(Math.min(v + (this.localRange * 3 >>> 2), ObjectMarker.this.bits.length) - this.localRange, 0);
        }

        private void calcRange() {
            if (this.sr == null) {
                if (DEBUG) {
                    System.out.println("Set local range=" + this.localRange);
                }
                this.sr = new SoftReference<int[]>(new int[1024]);
            } else if (this.sr.get() != null) {
                if (this.localRange < ObjectMarker.this.bits.length && this.scaleUp > 0.0) {
                    this.localRange = Math.min((int)((double)this.localRange * (1.0 + this.scaleUp)), ObjectMarker.this.bits.length);
                    if (DEBUG) {
                        System.out.println("Increased local range=" + this.localRange + " " + this.scaleUp);
                    }
                }
            } else if (this.localRange != this.localRangeLimit || this.scaleUp != 0.0) {
                this.localRange = Math.max((int)((double)this.localRange * 0.9), this.localRangeLimit);
                this.scaleUp *= 0.5;
                if (this.scaleUp * (double)this.localRange < 1.0) {
                    this.scaleUp = 0.0;
                }
                if (DEBUG) {
                    System.out.println("Decreased local range=" + this.localRange + " " + this.scaleUp);
                }
                this.sr = new SoftReference<int[]>(new int[1024]);
            }
        }
    }

    static class MultiThreadedRootStack
    extends IntStack {
        private int waitingThreads;
        private int totalThreads;
        private int waits;
        private long waitsduration;
        static final int RESERVED_WAITING = 20;
        static final int RESERVED_RUNNING = 5;
        int totalWork;
        int worked;
        int pushed;
        int lastDone;

        MultiThreadedRootStack(int n) {
            super(n);
            this.totalWork = n;
            this.pushed = n;
        }

        synchronized void linkThread() {
            ++this.totalThreads;
        }

        synchronized void unlinkThread() {
            --this.totalThreads;
            if (this.waitingThreads >= this.totalThreads) {
                this.notifyAll();
                if (DEBUG && this.totalThreads == 0) {
                    System.out.println("Total waits " + this.waits + " " + this.waitsduration + "ms");
                }
            }
        }

        int worked() {
            int done = this.pushed - this.size();
            int newDone = done - this.lastDone;
            int ticksLeft = this.totalWork - this.worked;
            if (newDone > 0) {
                int k = ticksLeft * newDone / (newDone + this.size());
                if (k < this.totalWork / 1000) {
                    k = 0;
                }
                if (k > 0) {
                    this.worked += k;
                    this.lastDone = done;
                }
                return k;
            }
            return 0;
        }

        int waitAndPop() {
            ++this.waitingThreads;
            long t = System.currentTimeMillis();
            ++this.waits;
            try {
                while (this.waitingThreads < this.totalThreads && this.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
            long t2 = System.currentTimeMillis();
            this.waitsduration += t2 - t;
            if (DEBUG && t2 - t > 10L) {
                System.out.println("Slow wait " + (t2 - t) + "ms " + Thread.currentThread() + " " + this.size());
            }
            if (this.waitingThreads >= this.totalThreads) {
                --this.waitingThreads;
                return -1;
            }
            --this.waitingThreads;
            return this.pop();
        }

        boolean pushIfWaiting(int z) {
            if (this.waitingThreads * 20 + (this.totalThreads - this.waitingThreads - 1) * 5 > this.size()) {
                this.push(z);
                ++this.pushed;
                if (this.waitingThreads > 0) {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }
    }
}

