/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;

public final class JavaModelUtils {
    private JavaModelUtils() {
    }

    public static boolean isJavaModelFile(IFile file) {
        if (!file.exists()) {
            return false;
        }
        try {
            IContentDescription contentDescription = file.getContentDescription();
            return "org.eclipse.modisco.java.contenttype".equals(contentDescription.getContentType().getId());
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            return file.toString().endsWith("_java.xmi");
        }
    }
}

