/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public final class OCLInput {
    private String textString;
    private Reader textReader;

    public OCLInput(String oclText) {
        this.textString = oclText;
    }

    public OCLInput(InputStream oclStream) {
        this.textReader = new InputStreamReader(oclStream, Charset.defaultCharset());
    }

    public OCLInput(InputStream oclStream, String encoding) throws UnsupportedEncodingException {
        this.textReader = new InputStreamReader(oclStream, encoding);
    }

    public OCLInput(Reader oclReader) {
        this.textReader = oclReader;
    }

    public char[] getContent() throws ParserException {
        if (this.textString != null) {
            return this.textString.toCharArray();
        }
        StringBuilder builder = this.buildStringFromReader();
        char[] result = new char[builder.length()];
        builder.getChars(0, result.length, result, 0);
        return result;
    }

    public String getContentAsString() throws ParserException {
        if (this.textString != null) {
            return this.textString;
        }
        StringBuilder builder = this.buildStringFromReader();
        return builder.toString();
    }

    private StringBuilder buildStringFromReader() throws ParserException {
        StringBuilder result = new StringBuilder();
        CharBuffer cbuf = CharBuffer.allocate(2048);
        try {
            try {
                int read;
                while ((read = this.textReader.read(cbuf)) >= 0) {
                    cbuf.flip();
                    result.append(cbuf);
                }
            }
            finally {
                this.textReader.close();
            }
        }
        catch (IOException e) {
            throw new ParserException(OCLMessages.bind(OCLMessages.Input_ERROR_, e.getLocalizedMessage()), e);
        }
        return result;
    }

    public Reader getContentAsStream() {
        if (this.textReader != null) {
            return this.textReader;
        }
        return new StringReader(this.textString);
    }
}

