/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IJavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.JavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginProjectEditor;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.xml.sax.SAXException;

public class PluginEditor
extends PluginProjectEditor
implements IPluginEditor {
    protected IManifestEditor manifest;
    protected IJavaProjectEditor java;

    public PluginEditor(IProject project) throws CoreException, IOException, SAXException, ParserConfigurationException {
        super(project);
        this.manifest = new ManifestEditor(project);
        this.java = new JavaProjectEditor(this);
    }

    public PluginProjectEditor getPluginEditor() {
        return this;
    }

    public IManifestEditor getManifestEditor() {
        return this.manifest;
    }

    public IJavaProjectEditor getJavaProjectEditor() {
        return this.java;
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> result = super.getMissingFiles();
        result.addAll(this.java.getMissingFiles());
        result.addAll(this.manifest.getMissingFiles());
        return result;
    }

    @Override
    public Set<String> getMissingNature() {
        Set<String> result = super.getMissingNature();
        result.addAll(this.java.getMissingNature());
        result.addAll(this.manifest.getMissingNature());
        return result;
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        Set<String> result = super.getMissingBuildCommand();
        result.addAll(this.java.getMissingBuildCommand());
        result.addAll(this.manifest.getMissingBuildCommand());
        return result;
    }

    @Override
    public void init() {
        super.init();
        this.java.init();
        this.manifest.init();
    }

    @Override
    public void create() {
        super.create();
        this.java.create();
        this.manifest.create();
    }

    @Override
    public void createFiles(Set<String> files) {
        super.createFiles(files);
        this.java.createFiles(files);
        this.manifest.createFiles(files);
    }

    @Override
    public boolean exists() {
        return this.java.exists() && this.manifest.exists();
    }

    @Override
    public boolean pluginManifestExists() {
        return super.exists();
    }

    @Override
    public void registerSourceFolder(String source) {
        this.java.registerSourceFolder(source);
    }

    @Override
    public void addToBuild(String path) {
        this.java.addToBuild(path);
    }

    @Override
    public String[] getSourceFolders() {
        return this.java.getSourceFolders();
    }

    @Override
    public void addDependency(String dependency) {
        this.manifest.addDependency(dependency);
    }

    @Override
    public void addDependency(String dependency, String version) {
        this.manifest.addDependency(dependency, version);
    }

    @Override
    public boolean hasDependency(String dependency) {
        return this.manifest.hasDependency(dependency);
    }

    @Override
    public void setValue(String key, String value) {
        this.manifest.setValue(key, value);
    }

    @Override
    public void setValue(String key, String name, String value) {
        this.manifest.setValue(key, name, value);
    }

    @Override
    public void removeValue(String key, String value) {
        this.manifest.removeValue(key, value);
    }

    @Override
    public void removeValue(String key) {
        this.manifest.removeValue(key);
    }

    @Override
    public void setBundleName(String name) {
        this.manifest.setBundleName(name);
    }

    @Override
    public String getSymbolicBundleName() {
        return this.manifest.getSymbolicBundleName();
    }

    @Override
    public String getBundleVersion() {
        return this.manifest.getBundleVersion();
    }

    @Override
    public void setBundleVersion(String version) {
        this.manifest.setBundleVersion(version);
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.manifest.isDirty() || this.java.isDirty();
    }

    @Override
    protected void doSave() {
        super.doSave();
        this.manifest.save();
        this.java.save();
    }

    @Override
    public void registerBinFolder(String binFolder) {
        this.java.registerBinFolder(binFolder);
    }

    @Override
    public void removeFromBuild(String path) {
        this.java.removeFromBuild(path);
    }

    @Override
    public boolean isRegisteredSourceFolder(String path) {
        return this.java.isRegisteredSourceFolder(path);
    }

    @Override
    public boolean isRegisteredBinFolder(String binFolder) {
        return this.java.isRegisteredBinFolder(binFolder);
    }

    @Override
    public String[] getElementsInBuild() {
        return this.java.getElementsInBuild();
    }

    @Override
    public String getBundleVendor() {
        return this.manifest.getBundleVendor();
    }

    @Override
    public void setBundleVendor(String vendor) {
        this.manifest.setBundleVendor(vendor);
    }

    @Override
    public String getValue(String key) {
        return this.manifest.getValue(key);
    }

    @Override
    public String getValue(String key, String name) {
        return this.manifest.getValue(key, name);
    }

    @Override
    public void setSymbolicBundleName(String name) {
        this.manifest.setSymbolicBundleName(name);
    }

    @Override
    public String getBundleName() {
        return this.manifest.getBundleName();
    }

    @Override
    public String getBundleLocalization() {
        return this.manifest.getBundleLocalization();
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.manifest.setSingleton(singleton);
    }

    @Override
    @Deprecated
    public void setDependenciesVersion(String dependencyPattern, String newVersion) {
        this.manifest.setDependenciesVersion(dependencyPattern, newVersion);
    }

    @Override
    public void addImportPackage(String packageName) {
        this.manifest.addImportPackage(packageName);
    }

    @Override
    public void addImportPackage(String packageName, String version) {
        this.manifest.addImportPackage(packageName, version);
    }

    @Override
    public void addExportPackage(String packageName) {
        this.manifest.addExportPackage(packageName);
    }

    @Override
    public void addExportPackage(String packageName, String version) {
        this.manifest.addExportPackage(packageName, version);
    }

    @Override
    public List<IRequiredBundleDescription> getRequiredBundles() {
        return this.manifest.getRequiredBundles();
    }

    @Override
    public List<IPackageImportDescription> getImportedPackages() {
        return this.manifest.getImportedPackages();
    }

    @Override
    public void setRequiredBundleExported(String bundleName, boolean exported) {
        this.manifest.setRequiredBundleExported(bundleName, exported);
    }

    @Override
    public void removeRequiredBundle(String bundleName) {
        this.manifest.removeRequiredBundle(bundleName);
    }

    @Override
    public void removeImportedPackage(String packageName) {
        this.manifest.removeImportedPackage(packageName);
    }

    @Override
    public void addJavaSourceFolder(String path) {
        this.java.addJavaSourceFolder(path);
    }

    @Override
    public void addSourceFolderToClasspath(String folderPath) {
        this.java.addSourceFolderToClasspath(folderPath);
    }

    @Override
    public void addSourceFolderToClasspath(String srcPath, String binPath) {
        this.java.addSourceFolderToClasspath(srcPath, binPath);
    }

    @Override
    public boolean isSourceFolderRegistered(String folderPath) {
        return this.java.isSourceFolderRegistered(folderPath);
    }

    @Override
    public String[] getBinFolders() {
        return this.java.getBinFolders();
    }
}

