/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.widgets.strategy.IStrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public abstract class AbstractTreeFilter
extends ViewerFilter {
    protected boolean useCache = true;
    protected boolean showIfHasVisibleParent = false;
    protected final Map<Object, Boolean> visibleElement = new HashMap<Object, Boolean>();
    protected final Map<Object, Boolean> visibleParent = new HashMap<Object, Boolean>();
    protected final Map<Object, Boolean> visibleChild = new HashMap<Object, Boolean>();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ProviderBasedBrowseStrategy strategy = null;
        if (viewer instanceof StructuredViewer) {
            IContentProvider baseContentProvider = ((StructuredViewer)viewer).getContentProvider();
            if (baseContentProvider instanceof IStrategyBasedContentProvider) {
                strategy = ((IStrategyBasedContentProvider)baseContentProvider).getRevealStrategy();
            }
            if (strategy == null && baseContentProvider instanceof ITreeContentProvider) {
                strategy = new ProviderBasedBrowseStrategy((ITreeContentProvider)baseContentProvider);
            }
        }
        if (strategy == null) {
            return this.isVisible(viewer, parentElement, element);
        }
        return this.select(viewer, parentElement, element, strategy);
    }

    protected boolean select(Viewer viewer, Object parentElement, Object element, TreeBrowseStrategy strategy) {
        boolean isVisible;
        HashSet<Object> visitedChildren = new HashSet<Object>();
        HashSet<Object> visitedParents = new HashSet<Object>();
        if (this.useCache && this.visibleElement.containsKey(element)) {
            return this.visibleElement.get(element);
        }
        boolean bl = isVisible = this.isVisible(viewer, parentElement, element) || this.hasOneVisibleChild(viewer, element, strategy, visitedChildren);
        if (this.showIfHasVisibleParent) {
            boolean bl2 = isVisible = isVisible || this.hasOneVisibleParent(viewer, element, strategy, visitedParents);
        }
        if (this.useCache) {
            this.visibleElement.put(element, isVisible);
        }
        return isVisible;
    }

    protected boolean hasOneVisibleChild(Viewer viewer, Object element, TreeBrowseStrategy strategy, Set<Object> visitedElements) {
        Object[] children;
        EObject eObject;
        if (this.useCache && this.visibleChild.containsKey(element)) {
            return this.visibleChild.get(element);
        }
        boolean result = false;
        boolean visited = false;
        if (visitedElements.contains(element)) {
            visited = true;
        } else {
            visitedElements.add(element);
        }
        if (!visited && (eObject = (EObject)PlatformHelper.getAdapter((Object)element, EObject.class)) != null && !element.equals(eObject)) {
            if (visitedElements.contains(eObject)) {
                visited = true;
            } else {
                visitedElements.add(eObject);
            }
        }
        if (!visited && (children = strategy.getChildren(element)) != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object childElement = objectArray[n2];
                if (this.isVisible(viewer, element, childElement) || this.hasOneVisibleChild(viewer, childElement, strategy, visitedElements)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        if (this.useCache) {
            this.visibleChild.put(element, result);
        }
        return result;
    }

    protected boolean hasOneVisibleParent(Viewer viewer, Object element, TreeBrowseStrategy strategy, Set<Object> visitedElements) {
        if (this.useCache && this.visibleParent.containsKey(element)) {
            return this.visibleParent.get(element);
        }
        boolean result = false;
        if (!visitedElements.contains(element)) {
            visitedElements.add(element);
            Object parentElement = strategy.getParent(element);
            if (parentElement == element || parentElement == null) {
                result = this.isVisible(viewer, parentElement, element);
            } else {
                boolean bl = result = this.isVisible(viewer, null, parentElement) || this.hasOneVisibleParent(viewer, parentElement, strategy, visitedElements);
            }
        }
        if (this.useCache) {
            this.visibleParent.put(element, result);
        }
        return result;
    }

    public void clearCache() {
        this.visibleElement.clear();
        this.visibleParent.clear();
        this.visibleChild.clear();
    }

    public abstract boolean isVisible(Viewer var1, Object var2, Object var3);

    public void setShowIfHasVisibleParent(boolean showIfHasVisibleParent) {
        this.showIfHasVisibleParent = showIfHasVisibleParent;
    }
}

