/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AffixedNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.BehaviorFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.LineDecorator;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.BehaviorPositionLocator;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.LineDecoratorLocator;
import org.eclipse.swt.graphics.Color;

public class PortFigure
extends AffixedNamedElementFigure {
    private BehaviorFigure myBehavior = null;
    private LineDecorator myLineDecor = null;

    public boolean isBehaviored() {
        return this.myBehavior != null && this.myLineDecor != null && this.getBorderItemContainer().getChildren().contains((Object)this.myBehavior) && this.getBorderItemContainer().getChildren().contains((Object)this.myBehavior);
    }

    public BehaviorFigure getBehavior() {
        return this.myBehavior;
    }

    public void restoreBehaviorFigure() {
        if (this.myBehavior == null) {
            this.myBehavior = this.createBehavior();
        }
        if (this.myLineDecor == null) {
            this.myLineDecor = this.createLineDecorator();
        }
        if (!this.getBorderItemContainer().getChildren().contains((Object)this.myBehavior)) {
            this.getBorderItemContainer().add((IFigure)this.myBehavior, (Object)new BehaviorPositionLocator(this));
        }
        if (!this.getBorderItemContainer().getChildren().contains((Object)this.myLineDecor)) {
            this.getBorderItemContainer().add((IFigure)this.myLineDecor, (Object)new LineDecoratorLocator(this));
        }
    }

    protected BehaviorFigure createBehavior() {
        BehaviorFigure behavior = new BehaviorFigure(this);
        behavior.setShadowColor(this.getShadowColor());
        behavior.setShadowWidth(this.getShadowWidth());
        behavior.setShadow(this.getShadow());
        behavior.setLineStyle(this.getLineStyle());
        behavior.setLineWidth(this.getLineWidth());
        behavior.setIsUsingGradient(false);
        behavior.setForegroundColor(this.getForegroundColor());
        behavior.setBackgroundColor(this.getForegroundColor());
        return behavior;
    }

    private LineDecorator createLineDecorator() {
        LineDecorator line = new LineDecorator();
        line.setForegroundColor(this.getForegroundColor());
        line.setBackgroundColor(this.getBackgroundColor());
        line.setLineWidth(this.getLineWidth());
        line.setLineStyle(this.getLineStyle());
        return line;
    }

    public void removeBehavior() {
        if (this.myBehavior != null && this.getBorderItemContainer().getChildren().contains((Object)this.myBehavior)) {
            this.getBorderItemContainer().remove((IFigure)this.myBehavior);
        }
        if (this.myLineDecor != null && this.getBorderItemContainer().getChildren().contains((Object)this.myLineDecor)) {
            this.getBorderItemContainer().remove((IFigure)this.myLineDecor);
        }
    }

    private IFigure getBorderItemContainer() {
        PortFigure borderedFigure = this;
        while (!(borderedFigure instanceof BorderedNodeFigure) && borderedFigure != null) {
            borderedFigure = borderedFigure.getParent();
        }
        return ((BorderedNodeFigure)borderedFigure).getBorderItemContainer();
    }

    public void setShadowColor(String shadowColor) {
        super.setShadowColor(shadowColor);
        if (this.myBehavior != null) {
            this.myBehavior.setShadowColor(shadowColor);
        }
    }

    public void setShadowWidth(int shadowWidth) {
        super.setShadowWidth(shadowWidth);
        if (this.myBehavior != null) {
            this.myBehavior.setShadowWidth(shadowWidth);
        }
    }

    public void setShadow(boolean shadow) {
        super.setShadow(shadow);
        if (this.myBehavior != null) {
            this.myBehavior.setShadow(shadow);
        }
    }

    public void setLineStyle(int s) {
        super.setLineStyle(s);
        if (this.myBehavior != null) {
            this.myBehavior.setLineStyle(s);
        }
        if (this.myLineDecor != null) {
            this.myLineDecor.setLineStyle(s);
        }
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
        if (this.myBehavior != null) {
            this.myBehavior.setLineWidth(w);
        }
        if (this.myLineDecor != null) {
            this.myLineDecor.setLineWidth(w);
        }
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.myBehavior != null) {
            this.myBehavior.setForegroundColor(fg);
            this.myBehavior.setBackgroundColor(fg);
        }
        if (this.myLineDecor != null) {
            this.myLineDecor.setForegroundColor(fg);
        }
    }
}

