/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableList;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class OwnedCommentsObservableList
extends PapyrusObservableList {
    public OwnedCommentsObservableList(EditingDomain domain, EObject source) {
        super(OwnedCommentsObservableList.getOwnedComments(source), domain, source, (EStructuralFeature)UMLPackage.eINSTANCE.getElement_OwnedComment());
    }

    private static List<Comment> getOwnedComments(EObject source) {
        LinkedList<Comment> result = new LinkedList<Comment>();
        if (source instanceof Element) {
            EList allOwnedComments = ((Element)source).getOwnedComments();
            for (Comment comment : allOwnedComments) {
                if (comment.getAnnotatedElements().contains((Object)source)) continue;
                result.add(comment);
            }
        }
        return result;
    }

    protected void refreshCacheList() {
        if (this.isDisposed()) {
            return;
        }
        this.wrappedList.clear();
        this.wrappedList.addAll(OwnedCommentsObservableList.getOwnedComments(this.source));
        this.fireListChange(null);
    }

    public Command getAddCommand(Object value) {
        assert (value instanceof Comment) : "Added value is not a Comment";
        SetRequest setRequest = new SetRequest((TransactionalEditingDomain)this.editingDomain, this.source, this.feature, value);
        return this.getCommandFromRequests(this.getProvider(), Collections.singletonList(setRequest));
    }

    public Command getRemoveCommand(Object value) {
        assert (value instanceof Comment) : "Deleted value is not a Comment";
        DestroyElementRequest destroyRequest = new DestroyElementRequest((TransactionalEditingDomain)this.editingDomain, (EObject)value, false);
        return this.getCommandFromRequests(this.getProvider(), Collections.singletonList(destroyRequest));
    }
}

