/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.PrintWriter;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.util.Printer;
import org.eclipse.persistence.internal.libraries.asm.util.Textifier;
import org.eclipse.persistence.internal.libraries.asm.util.TraceAnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.TraceFieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.TraceMethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.TraceModuleVisitor;

public final class TraceClassVisitor
extends ClassVisitor {
    private final PrintWriter pw;
    public final Printer p;

    public TraceClassVisitor(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        this(classVisitor, new Textifier(), printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, Printer printer, PrintWriter printWriter) {
        super(393216, classVisitor);
        this.pw = printWriter;
        this.p = printer;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.p.visit(n, n2, string, string2, string3, stringArray);
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        this.p.visitSource(string, string2);
        super.visitSource(string, string2);
    }

    @Override
    public ModuleVisitor visitModule(String string, int n, String string2) {
        Printer printer = this.p.visitModule(string, n, string2);
        ModuleVisitor moduleVisitor = super.visitModule(string, n, string2);
        return new TraceModuleVisitor(moduleVisitor, printer);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.p.visitOuterClass(string, string2, string3);
        super.visitOuterClass(string, string2, string3);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        Printer printer = this.p.visitClassAnnotation(string, bl);
        AnnotationVisitor annotationVisitor = this.cv == null ? null : this.cv.visitAnnotation(string, bl);
        return new TraceAnnotationVisitor(annotationVisitor, printer);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        Printer printer = this.p.visitClassTypeAnnotation(n, typePath, string, bl);
        AnnotationVisitor annotationVisitor = this.cv == null ? null : this.cv.visitTypeAnnotation(n, typePath, string, bl);
        return new TraceAnnotationVisitor(annotationVisitor, printer);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.p.visitClassAttribute(attribute);
        super.visitAttribute(attribute);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.p.visitInnerClass(string, string2, string3, n);
        super.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        Printer printer = this.p.visitField(n, string, string2, string3, object);
        FieldVisitor fieldVisitor = this.cv == null ? null : this.cv.visitField(n, string, string2, string3, object);
        return new TraceFieldVisitor(fieldVisitor, printer);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        Printer printer = this.p.visitMethod(n, string, string2, string3, stringArray);
        MethodVisitor methodVisitor = this.cv == null ? null : this.cv.visitMethod(n, string, string2, string3, stringArray);
        return new TraceMethodVisitor(methodVisitor, printer);
    }

    @Override
    public void visitEnd() {
        this.p.visitClassEnd();
        if (this.pw != null) {
            this.p.print(this.pw);
            this.pw.flush();
        }
        super.visitEnd();
    }
}

