/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.WarArchiver;
import org.eclipse.persistence.tools.dbws.WarPackager;

public class JBossPackager
extends WarPackager {
    static final String deploymentDescriptorFileName = "jboss-deployment-structure.xml";
    static final String deploymentDescriptorXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jboss-deployment-structure>\n   <deployment>\n      <dependencies>\n         <module name=\"org.eclipse.persistence\" />\n      </dependencies>\n   </deployment>\n</jboss-deployment-structure>";

    public JBossPackager() {
        this(new WarArchiver(), "jboss", DBWSPackager.ArchiveUse.archive);
    }

    protected JBossPackager(DBWSPackager.Archiver archiver, String packagerLabel, DBWSPackager.ArchiveUse useJavaArchive) {
        super(archiver, packagerLabel, useJavaArchive);
    }

    @Override
    public void writeDeploymentDescriptor(OutputStream descriptorOutputStream) {
        OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(descriptorOutputStream));
        try {
            osw.write(deploymentDescriptorXml);
            osw.flush();
        }
        catch (IOException iOException) {}
    }

    @Override
    public OutputStream getDeploymentDescriptorStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, deploymentDescriptorFileName));
    }

    @Override
    public void closeDeploymentDescriptorStream(OutputStream descriptorOutputStream) {
        this.closeStream(descriptorOutputStream);
    }

    @Override
    public String getDeploymentDescriptorFileName() {
        return deploymentDescriptorFileName;
    }

    @Override
    public SessionConfigs buildSessionsXML(OutputStream dbwsSessionsStream, DBWSBuilder builder) {
        SessionConfigs ts = super.buildSessionsXML(dbwsSessionsStream, builder);
        String dataSource = builder.getDataSource();
        if (dataSource != null) {
            DatabaseSessionConfig tmpConfig = (DatabaseSessionConfig)ts.getSessionConfigs().firstElement();
            ProjectConfig orProject = tmpConfig.getPrimaryProject();
            LogConfig logConfig = tmpConfig.getLogConfig();
            String sessionName = tmpConfig.getName();
            ServerSessionConfig orSessionConfig = new ServerSessionConfig();
            orSessionConfig.setPrimaryProject(orProject);
            orSessionConfig.setName(sessionName);
            orSessionConfig.setLogConfig(logConfig);
            CustomServerPlatformConfig customServerPlatformConfig = new CustomServerPlatformConfig();
            customServerPlatformConfig.setEnableJTA(true);
            customServerPlatformConfig.setEnableRuntimeServices(true);
            customServerPlatformConfig.setServerClassName("org.eclipse.persistence.platform.server.jboss.JBossPlatform");
            customServerPlatformConfig.setExternalTransactionControllerClass("org.eclipse.persistence.transaction.jboss.JBossTransactionController");
            orSessionConfig.setServerPlatformConfig((ServerPlatformConfig)customServerPlatformConfig);
            DatabaseLoginConfig dlc = new DatabaseLoginConfig();
            dlc.setPlatformClass(builder.getPlatformClassname());
            dlc.setExternalConnectionPooling(true);
            dlc.setExternalTransactionController(true);
            dlc.setDatasource(dataSource);
            dlc.setLookupType(Integer.valueOf(1));
            dlc.setBindAllParameters(true);
            dlc.setStreamsForBinding(true);
            orSessionConfig.setLoginConfig((LoginConfig)dlc);
            ts.getSessionConfigs().set(0, orSessionConfig);
        }
        return ts;
    }
}

