/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.rcptt.ecl.platform.internal.PlatformPlugin;
import org.eclipse.rcptt.ecl.platform.internal.log.LogEntry;
import org.eclipse.rcptt.ecl.platform.objects.InstallUnit;
import org.eclipse.rcptt.ecl.platform.objects.LogMessage;
import org.eclipse.rcptt.ecl.platform.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.platform.objects.Repository;
import org.eclipse.rcptt.ecl.platform.objects.UpdateResult;

public class EclPlatformUtil {
    public static InstallUnit[] getInstallUnits() {
        IProfile profile = PlatformPlugin.getProfileRegistry().getProfile("_SELF_");
        if (profile == null) {
            return new InstallUnit[0];
        }
        UserVisibleRootQuery query = new UserVisibleRootQuery();
        IQueryResult queryResult = profile.query((IQuery)query, null);
        ArrayList<InstallUnit> result = new ArrayList<InstallUnit>();
        for (IInstallableUnit unit : queryResult.toSet()) {
            result.add(EclPlatformUtil.convertUnit(unit));
        }
        return result.toArray(new InstallUnit[result.size()]);
    }

    private static InstallUnit convertUnit(IInstallableUnit unit) {
        InstallUnit result = ObjectsFactory.eINSTANCE.createInstallUnit();
        result.setId(unit.getId());
        result.setName(unit.getProperty("org.eclipse.equinox.p2.name"));
        result.setVersion(unit.getVersion().toString());
        return result;
    }

    public static void addRepository(URI uri, String nick) {
        EclPlatformUtil.addRepo(PlatformPlugin.getMetadataMgr(), uri, nick);
        EclPlatformUtil.addRepo(PlatformPlugin.getArtifactMgr(), uri, nick);
    }

    public static void removeRepository(URI uri) {
        PlatformPlugin.getArtifactMgr().removeRepository(uri);
        PlatformPlugin.getMetadataMgr().removeRepository(uri);
    }

    private static void addRepo(IRepositoryManager<?> mgr, URI uri, String name) {
        mgr.addRepository(uri);
        if (name != null) {
            mgr.setRepositoryProperty(uri, "p2.nickname", name);
        }
    }

    public static Repository[] listRepositories() {
        ArrayList<Repository> result = new ArrayList<Repository>();
        IMetadataRepositoryManager metadataManager = PlatformPlugin.getMetadataMgr();
        IArtifactRepositoryManager artifactManager = PlatformPlugin.getArtifactMgr();
        HashSet<URI> allUris = new HashSet<URI>();
        int flags = 0;
        allUris.addAll(Arrays.asList(metadataManager.getKnownRepositories(flags)));
        allUris.addAll(Arrays.asList(artifactManager.getKnownRepositories(flags)));
        for (URI uri : allUris) {
            Repository site = ObjectsFactory.eINSTANCE.createRepository();
            site.setLocation(uri.toString());
            site.setIsMetadata(metadataManager.contains(uri));
            site.setIsArtifact(artifactManager.contains(uri));
            String nickname = metadataManager.getRepositoryProperty(uri, "p2.nickname");
            if (nickname == null) {
                nickname = artifactManager.getRepositoryProperty(uri, "p2.nickname");
            }
            if (nickname == null) {
                nickname = artifactManager.getRepositoryProperty(uri, "name");
            }
            if (nickname == null) {
                nickname = metadataManager.getRepositoryProperty(uri, "name");
            }
            if (nickname != null) {
                site.setName(nickname);
            }
            result.add(site);
        }
        return result.toArray(new Repository[result.size()]);
    }

    public static void replaceReposotory(URI uri, String nick) {
        Repository[] repositoryArray = EclPlatformUtil.listRepositories();
        int n = repositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            if (nick.equals(repo.getName())) {
                EclPlatformUtil.removeRepository(URI.create(repo.getLocation()));
            }
            ++n2;
        }
        EclPlatformUtil.addRepository(uri, nick);
    }

    public static UpdateResult[] update() throws CoreException {
        EclPlatformUtil.cleanOldProfiles();
        ArrayList<UpdateResult> result = new ArrayList<UpdateResult>();
        ProvisioningSession session = PlatformPlugin.createProvisioningSession();
        UpdateOperation operation = new UpdateOperation(session);
        IStatus status = operation.resolveModal((IProgressMonitor)new NullProgressMonitor());
        if (status.getCode() == 10000) {
            return new UpdateResult[0];
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        Update[] updateArray = operation.getSelectedUpdates();
        int n = updateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Update u = updateArray[n2];
            UpdateResult resultChild = ObjectsFactory.eINSTANCE.createUpdateResult();
            resultChild.setId(u.replacement.getId());
            resultChild.setFrom(u.toUpdate.getVersion().toString());
            resultChild.setTo(u.replacement.getVersion().toString());
            result.add(resultChild);
            ++n2;
        }
        ProvisioningJob job = operation.getProvisioningJob(null);
        if (job instanceof ProfileModificationJob) {
            ((ProfileModificationJob)job).setRestartPolicy(3);
        }
        if (job == null) {
            return new UpdateResult[0];
        }
        status = job.runModal((IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        return result.toArray(new UpdateResult[result.size()]);
    }

    public static void cleanOldProfiles() throws CoreException {
    }

    public static LogMessage createMessage(LogEntry entry) {
        LogMessage result = ObjectsFactory.eINSTANCE.createLogMessage();
        result.setDateText(entry.getFormattedDate());
        result.setMessage(entry.getMessage());
        result.setSeverity(entry.getSeverityText());
        result.setPluginId(entry.getPluginId());
        return result;
    }

    public static List<String> getWorkspaceResources(IContainer cont, String path, boolean findAll) throws CoreException {
        String resRegex;
        String trimmedPath;
        ArrayList<String> result = new ArrayList<String>();
        if (path == null) {
            return result;
        }
        IResource[] resources = cont.members();
        int slashInd = path.indexOf(47);
        if (slashInd != -1) {
            trimmedPath = path.substring(slashInd + 1);
            resRegex = path.substring(0, slashInd);
        } else {
            trimmedPath = null;
            resRegex = path;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            String name = res.getName();
            if (name.matches(resRegex)) {
                if (res instanceof IContainer) {
                    if (trimmedPath != null) {
                        result.addAll(EclPlatformUtil.getWorkspaceResources((IContainer)res, trimmedPath, findAll));
                        if (result.size() > 0 && !findAll) {
                            return result;
                        }
                    }
                } else {
                    result.add(res.getFullPath().toString());
                    if (!findAll) {
                        return result;
                    }
                }
            }
            ++n2;
        }
        return result;
    }
}

