/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.proxy.protocol.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;

public class SerializableFileInfo
implements Serializable {
    private static final long serialVersionUID = -1986643088683154145L;
    private IFileInfo info;

    public SerializableFileInfo() {
    }

    public SerializableFileInfo(IFileInfo info) {
        this.setIFileInfo(info);
    }

    public void setIFileInfo(IFileInfo info) {
        this.info = info;
    }

    public IFileInfo getIFileInfo() {
        return this.info;
    }

    public void writeObject(DataOutputStream out) throws IOException {
        out.writeUTF(this.info.getName());
        boolean symlink = this.info.getAttribute(32);
        out.writeBoolean(symlink);
        if (symlink) {
            out.writeUTF(this.info.getStringAttribute(64));
        }
        out.writeBoolean(this.info.exists());
        out.writeLong(this.info.getLastModified());
        out.writeLong(this.info.getLength());
        out.writeBoolean(this.info.isDirectory());
        out.writeBoolean(this.info.getAttribute(0x2000000));
        out.writeBoolean(this.info.getAttribute(0x4000000));
        out.writeBoolean(this.info.getAttribute(0x8000000));
        out.writeBoolean(this.info.getAttribute(0x10000000));
        out.writeBoolean(this.info.getAttribute(0x20000000));
        out.writeBoolean(this.info.getAttribute(0x40000000));
        out.writeBoolean(this.info.getAttribute(0x400000));
        out.writeBoolean(this.info.getAttribute(0x800000));
        out.writeBoolean(this.info.getAttribute(0x1000000));
    }

    public void readObject(DataInputStream in) throws IOException {
        FileInfo newInfo = new FileInfo();
        try {
            newInfo.setName(in.readUTF());
            boolean symlink = in.readBoolean();
            newInfo.setAttribute(32, symlink);
            if (symlink) {
                newInfo.setStringAttribute(64, in.readUTF());
            }
            newInfo.setExists(in.readBoolean());
            newInfo.setLastModified(in.readLong());
            newInfo.setLength(in.readLong());
            newInfo.setDirectory(in.readBoolean());
            newInfo.setAttribute(0x2000000, in.readBoolean());
            newInfo.setAttribute(0x4000000, in.readBoolean());
            newInfo.setAttribute(0x8000000, in.readBoolean());
            newInfo.setAttribute(0x10000000, in.readBoolean());
            newInfo.setAttribute(0x20000000, in.readBoolean());
            newInfo.setAttribute(0x40000000, in.readBoolean());
            newInfo.setAttribute(0x400000, in.readBoolean());
            newInfo.setAttribute(0x800000, in.readBoolean());
            newInfo.setAttribute(0x1000000, in.readBoolean());
        }
        catch (IOException iOException) {
            newInfo.setError(5);
        }
        this.setIFileInfo((IFileInfo)newInfo);
    }
}

