/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDACascadeByProfileAction;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.actions.SystemWorkWithUDAsAction;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.actions.SystemBaseDummyAction;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.swt.widgets.Shell;

public class SystemUDACascadeAction
extends SystemBaseSubMenuAction
implements IMenuListener {
    private SystemUDActionSubsystem udsubsystem;
    private SystemWorkWithUDAsAction wwAction;

    public SystemUDACascadeAction(SystemUDActionSubsystem udsubsystem, IStructuredSelection selection) {
        super(SystemUDAResources.ACTION_UDA_CASCADE_LABEL, SystemUDAResources.ACTION_UDA_CASCADE_TOOLTIP, null);
        this.udsubsystem = udsubsystem;
        super.setSelection((ISelection)selection);
        this.setCreateMenuEachTime(false);
        this.setPopulateMenuEachTime(true);
    }

    public IMenuManager populateSubMenu(IMenuManager menu) {
        menu.addMenuListener((IMenuListener)this);
        menu.setRemoveAllWhenShown(true);
        menu.add((IAction)new SystemBaseDummyAction());
        return menu;
    }

    public void menuAboutToShow(IMenuManager ourSubMenu) {
        Shell shell = this.getShell();
        if (!SystemPreferencesManager.getCascadeUserActions()) {
            this.udsubsystem.addUserActions(ourSubMenu, this.getSelection(), null, shell);
        } else {
            ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
            int idx = 0;
            while (idx < activeProfiles.length) {
                SystemUDACascadeByProfileAction profileAction = new SystemUDACascadeByProfileAction(shell, this.udsubsystem, this.getSelection(), activeProfiles[idx]);
                ourSubMenu.add((IContributionItem)profileAction.getSubMenu());
                ++idx;
            }
        }
        ourSubMenu.add((IContributionItem)new Separator("group.workwith"));
        if (this.wwAction == null) {
            this.wwAction = new SystemWorkWithUDAsAction(shell, this.udsubsystem.getSubsystem(), this.udsubsystem);
            this.wwAction.setText(SystemUDAResources.RESID_WORKWITH_UDAS_ACTION_LABEL);
            this.wwAction.setToolTipText(SystemUDAResources.RESID_WORKWITH_UDAS_ACTION_TOOLTIP);
            this.wwAction.allowOnMultipleSelection(true);
        }
        ourSubMenu.appendToGroup("group.workwith", (IAction)this.wwAction);
    }

    public void setInputs(Shell shell, Viewer v, ISelection selection) {
        super.setInputs(shell, v, selection);
    }
}

