/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ValueFromListPossibleValuesService
extends PossibleValuesService {
    private PossibleValuesService base;
    private Listener listener;
    private boolean refreshing;

    @Override
    protected void initPossibleValuesService() {
        Property parent = this.context(Element.class).parent();
        this.base = parent.service(PossibleValuesService.class);
        this.listener = new Listener(){

            @Override
            public void handle(Event event) {
                if (!ValueFromListPossibleValuesService.this.refreshing) {
                    try {
                        ValueFromListPossibleValuesService.this.refreshing = true;
                        ValueFromListPossibleValuesService.this.refresh();
                    }
                    finally {
                        ValueFromListPossibleValuesService.this.refreshing = false;
                    }
                }
            }
        };
        this.base.attach(this.listener);
    }

    @Override
    protected void compute(Set<String> values) {
        values.addAll(this.base.values());
    }

    @Override
    public Status problem(Value<?> value) {
        return this.base.problem(value);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.base.detach(this.listener);
            this.listener = null;
        }
        this.base = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property parent;
            ElementType type;
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && (type = property.getModelElementType()).properties().size() == 1 && (parent = context.find(Element.class).parent()) != null && parent.definition() instanceof ListProperty && parent.service(PossibleValuesService.class) != null;
        }
    }
}

