/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramConnectionPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramNodePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPagePresentation;

public class DiagramModel
extends DiagramModelBase {
    public static final String NODE_ADDED = "NODE_ADDED";
    public static final String NODE_REMOVED = "NODE_REMOVED";
    private DiagramPagePresentation diagramPresentation;
    private List<DiagramNodeModel> nodes = new ArrayList<DiagramNodeModel>();
    private List<DiagramConnectionModel> connections = new ArrayList<DiagramConnectionModel>();

    public DiagramModel(DiagramPagePresentation diagramPresentation) {
        this.diagramPresentation = diagramPresentation;
        this.contructNodes();
        this.constructConnections();
        diagramPresentation.init(this);
    }

    public DiagramPagePresentation getPresentation() {
        return this.diagramPresentation;
    }

    public SapphireDiagramEditorPagePart getSapphirePart() {
        return this.diagramPresentation.part();
    }

    public List<DiagramNodeModel> getNodes() {
        return this.nodes;
    }

    public List<DiagramConnectionModel> getConnections() {
        return this.connections;
    }

    public DiagramConfigurationManager getConfigurationManager() {
        return this.diagramPresentation.getConfigurationManager();
    }

    public DiagramNodeModel getDiagramNodeModel(DiagramNodePart nodePart) {
        for (DiagramNodeModel nodeModel : this.nodes) {
            if (nodeModel.getModelPart() != nodePart) continue;
            return nodeModel;
        }
        return null;
    }

    public DiagramConnectionModel getDiagramConnectionModel(DiagramConnectionPart connectionPart) {
        for (DiagramConnectionModel connectionModel : this.connections) {
            if (connectionModel.getModelPart() != connectionPart) continue;
            return connectionModel;
        }
        return null;
    }

    public void handleAddNode(DiagramNodePart nodePart) {
        DiagramNodePresentation nodePresentation = this.getPresentation().addNode(nodePart);
        DiagramNodeModel nodeModel = new DiagramNodeModel(this, nodePresentation);
        DiagramNodeBounds bounds = nodePart.getNodeBounds();
        if (bounds.getX() < 0 && bounds.getY() < 0) {
            Point position = this.getDefaultPosition();
            nodePart.setNodeBounds(position.getX(), position.getY(), false, true);
        }
        this.nodes.add(nodeModel);
        this.firePropertyChange(NODE_ADDED, null, nodeModel);
    }

    public void handleDirectEditing(DiagramNodePart nodePart) {
        DiagramNodeModel nodeModel = this.getDiagramNodeModel(nodePart);
        if (nodeModel != null) {
            nodeModel.handleStartEditing();
        }
    }

    public void handleDirectEditing(ShapePart shapePart) {
        DiagramNodePart nodePart = (DiagramNodePart)shapePart.nearest(DiagramNodePart.class);
        DiagramNodeModel nodeModel = this.getDiagramNodeModel(nodePart);
        if (nodeModel != null) {
            nodeModel.handleStartEditing(shapePart);
        }
    }

    public void handleDirectEditing(DiagramConnectionPart connectionPart) {
        DiagramConnectionModel connectionModel = this.getDiagramConnectionModel(connectionPart);
        if (connectionModel != null) {
            connectionModel.handleStartEditing();
        }
    }

    public void handleRemoveNode(DiagramNodePart nodePart) {
        DiagramNodeModel nodeModel = this.getDiagramNodeModel(nodePart);
        if (nodeModel != null) {
            this.nodes.remove(nodeModel);
            this.firePropertyChange(NODE_REMOVED, null, nodePart);
        }
    }

    public void handleMoveNode(DiagramNodePart nodePart) {
        DiagramNodeModel nodeModel = this.getDiagramNodeModel(nodePart);
        if (nodeModel != null) {
            nodeModel.handleMoveNode();
        }
    }

    private void contructNodes() {
        for (DiagramNodePresentation nodePresentation : this.getPresentation().getNodes()) {
            this.nodes.add(new DiagramNodeModel(this, nodePresentation));
        }
    }

    private void constructConnections() {
        ConnectionService connService = (ConnectionService)this.getSapphirePart().service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            this.addConnection(connPart);
        }
    }

    public void addConnection(DiagramConnectionPart connPart) {
        if (this.getDiagramConnectionModel(connPart) != null) {
            return;
        }
        Element endpoint1 = connPart.getEndpoint1();
        Element endpoint2 = connPart.getEndpoint2();
        DiagramNodePart nodePart1 = this.getSapphirePart().getDiagramNodePart(endpoint1);
        DiagramNodePart nodePart2 = this.getSapphirePart().getDiagramNodePart(endpoint2);
        if (nodePart1 != null && nodePart2 != null) {
            DiagramConnectionPresentation connPresentation = new DiagramConnectionPresentation(connPart, this.getPresentation(), this.getPresentation().shell(), this.getConfigurationManager(), this.getResourceCache());
            DiagramConnectionModel connectionModel = new DiagramConnectionModel(this, connPresentation);
            this.connections.add(connectionModel);
            DiagramNodeModel sourceNode = this.getDiagramNodeModel(nodePart1);
            DiagramNodeModel targetNode = this.getDiagramNodeModel(nodePart2);
            if (sourceNode != null && targetNode != null) {
                sourceNode.addSourceConnection(connectionModel);
                targetNode.addTargetConnection(connectionModel);
                connectionModel.setSourceNode(sourceNode);
                connectionModel.setTargetNode(targetNode);
                org.eclipse.draw2d.geometry.Point bendPoint = this.getConfigurationManager().getConnectionRouter().route(connectionModel);
                DiagramLayoutPersistenceService persistenceService = (DiagramLayoutPersistenceService)this.getSapphirePart().service(DiagramLayoutPersistenceService.class);
                if (persistenceService.read(connPart) == null && bendPoint != null && connPart.getBendpoints().isEmpty()) {
                    ArrayList<Point> bendPoints = new ArrayList<Point>(1);
                    bendPoints.add(new Point(bendPoint.x, bendPoint.y));
                    connectionModel.getModelPart().resetBendpoints(bendPoints);
                }
            }
        }
    }

    public void removeConnection(DiagramConnectionPart connPart) {
        DiagramConnectionModel connectionModel = this.getDiagramConnectionModel(connPart);
        if (connectionModel != null) {
            this.removeConnection(connectionModel);
        }
    }

    public void updateConnectionEndpoint(DiagramConnectionPart connPart) {
        DiagramNodePart oldPart2;
        Element endpoint1 = connPart.getEndpoint1();
        Element endpoint2 = connPart.getEndpoint2();
        DiagramNodePart nodePart1 = this.getSapphirePart().getDiagramNodePart(endpoint1);
        DiagramNodePart nodePart2 = this.getSapphirePart().getDiagramNodePart(endpoint2);
        DiagramConnectionModel connectionModel = this.getDiagramConnectionModel(connPart);
        DiagramNodePart oldPart1 = connectionModel == null ? null : connectionModel.getSourceNode().getModelPart();
        DiagramNodePart diagramNodePart = oldPart2 = connectionModel == null ? null : connectionModel.getTargetNode().getModelPart();
        if (nodePart1 != oldPart1 || nodePart2 != oldPart2) {
            this.removeConnection(connPart);
            if (nodePart1 != null && nodePart2 != null) {
                this.addConnection(connPart);
            }
        }
    }

    public DiagramResourceCache getResourceCache() {
        return this.getPresentation().getResourceCache();
    }

    private void removeConnection(DiagramConnectionModel connectionModel) {
        this.getConfigurationManager().getConnectionRouter().removeConnectionFromCache(connectionModel);
        DiagramNodeModel sourceNode = connectionModel.getSourceNode();
        DiagramNodeModel targetNode = connectionModel.getTargetNode();
        if (sourceNode != null && targetNode != null) {
            sourceNode.removeSourceConnection(connectionModel);
            targetNode.removeTargetConnection(connectionModel);
            connectionModel.setSourceNode(null);
            connectionModel.setTargetNode(null);
        }
        this.connections.remove(connectionModel);
    }

    private Point getDefaultPosition() {
        int x = 10;
        int y = -1;
        for (DiagramNodeModel nodeModel : this.nodes) {
            Bounds bounds = nodeModel.getNodeBounds();
            int height = bounds.getHeight();
            if (height == -1) {
                height = nodeModel.getNodePresentation().getFigure().getBounds().height;
            }
            y = Math.max(y, height += bounds.getY() + 10);
        }
        return new Point(x, y);
    }

    public SapphireDiagramEditor getSapphireDiagramEditor() {
        return this.getConfigurationManager().getDiagramEditor();
    }
}

