/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.views.documentation;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.ui.views.documentation.DocumentationViewFormatterDescriptor;
import org.eclipse.sphinx.platform.ui.views.documentation.DocumentationViewFormatterDescriptorRegistry;
import org.eclipse.sphinx.platform.ui.views.documentation.IDescriptionWrapper;
import org.eclipse.sphinx.platform.ui.views.documentation.IDocumentationSection;
import org.eclipse.sphinx.platform.ui.views.documentation.IDocumentationViewFormatter;
import org.eclipse.sphinx.platform.ui.views.documentation.ITitleProvider;
import org.eclipse.sphinx.platform.ui.views.documentation.bootstrap.BootstrapDescriptionWrapper;
import org.eclipse.sphinx.platform.ui.views.documentation.bootstrap.BootstrapFormatterHTML;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class DocumentationView
extends ViewPart {
    public static final String ID = "org.eclipse.sphinx.platform.ui.views.documentation.DocumentationView";
    private Browser browser;
    protected IDescriptionWrapper wrapper = new BootstrapDescriptionWrapper();
    private ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            String topTitle = Messages.title_documentation;
            ArrayList allSections = Lists.newArrayList();
            while (iterator.hasNext()) {
                Object selectedObject = iterator.next();
                Iterable<DocumentationViewFormatterDescriptor> applicableDocViewFormatters = DocumentationViewFormatterDescriptorRegistry.INSTANCE.getApplicableDocViewFormatterFor(selectedObject);
                List sortedApplicableDocViewFormatters = DocumentationViewFormatterDescriptorRegistry.INSTANCE.docViewFormatterOrdering.sortedCopy(applicableDocViewFormatters);
                Iterable formatters = Iterables.transform((Iterable)sortedApplicableDocViewFormatters, (Function)new Function<DocumentationViewFormatterDescriptor, IDocumentationViewFormatter>(){

                    public IDocumentationViewFormatter apply(DocumentationViewFormatterDescriptor descriptor) {
                        try {
                            return (IDocumentationViewFormatter)descriptor.getInstance();
                        }
                        catch (Exception ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
                            return null;
                        }
                    }
                });
                for (IDocumentationViewFormatter formatter : formatters) {
                    if (formatter != null) {
                        List<IDocumentationSection> formatterSections = formatter.getDocumentationSectionFor(selectedObject);
                        allSections.addAll(formatterSections);
                        for (IDocumentationSection section : formatterSections) {
                            if (section.getSectionTitle() == null || section.getSectionTitle().length() <= 0 || section.getSectionBody() == null || section.getSectionBody().trim().length() <= 0) continue;
                            builder.append(DocumentationView.this.wrapper.textPre());
                            builder.append("<h3>" + section.getSectionTitle() + "</h3>");
                            builder.append(String.valueOf(section.getSectionBody()) + DocumentationView.this.wrapper.textPost());
                        }
                    }
                    if (!(formatter instanceof ITitleProvider)) continue;
                    topTitle = ((ITitleProvider)((Object)formatter)).getTitle(selectedObject);
                }
            }
            DocumentationView.this.browser.setText(BootstrapFormatterHTML.format(topTitle, builder.toString(), allSections));
        }
    };

    public void createPartControl(Composite parent) {
        try {
            this.browser = new Browser(parent, 0);
            String html = "<HTML><BODY>";
            html = String.valueOf(html) + "<P>" + Messages.desc_model_object_selection + "</P>";
            html = String.valueOf(html) + "</BODY></HTML>";
            this.browser.setText(html);
            this.getSite().getPage().addSelectionListener(this.listener);
        }
        catch (SWTError ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
            return;
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.listener);
        super.dispose();
    }
}

