/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.core.interfaces.IConnectable;
import org.eclipse.tcf.te.core.utils.ConnectStateHelper;
import org.eclipse.tcf.te.ui.handler.AbstractCommandHandler;
import org.eclipse.tcf.te.ui.jface.dialogs.OptionalMessageDialog;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConnectableCommandHandler
extends AbstractCommandHandler
implements IExecutableExtension {
    protected static final String PARAM_ACTION = "action";
    protected static final String PARAM_HANDLE_DIRTY = "handleDirty";
    protected int action = 0;
    protected boolean handleDirty = false;

    public int getAction() {
        return this.action;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        List<IConnectable> connectables = this.getConnectables(selection);
        if (this.handleDirty) {
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                if (ref.isDirty()) {
                    try {
                        IConnectable connectable = this.getConnectable(ref.getEditorInput());
                        if (connectable != null && connectables.contains(connectable)) {
                            int result = OptionalMessageDialog.openYesNoCancelDialog((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.AbstractEditorCommandHandler_saveDialog_title, (String)NLS.bind((String)Messages.AbstractEditorCommandHandler_saveDialog_message, (Object)ref.getTitle()), null, null);
                            switch (result) {
                                case 2: {
                                    ref.getEditor(true).doSave(null);
                                    break;
                                }
                                case 1: {
                                    return null;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        return this.internalExecute(event, selection, connectables);
    }

    public Object internalExecute(ExecutionEvent event, IStructuredSelection selection, List<IConnectable> connectables) {
        for (IConnectable connectable : connectables) {
            if (!connectable.isConnectStateChangeAllowed(this.action)) continue;
            connectable.changeConnectState(this.action, null, null);
        }
        return null;
    }

    protected List<IConnectable> getConnectables(IStructuredSelection selection) {
        ArrayList<IConnectable> connectables = new ArrayList<IConnectable>();
        for (Object element : selection) {
            IConnectable connectable = this.getConnectable(element);
            if (connectable == null || connectables.contains(connectable)) continue;
            connectables.add(connectable);
        }
        return connectables;
    }

    protected IConnectable getConnectable(Object element) {
        IConnectable connectable = null;
        if (element instanceof IConnectable) {
            connectable = (IConnectable)element;
        } else if (element instanceof IAdaptable) {
            connectable = (IConnectable)((IAdaptable)element).getAdapter(IConnectable.class);
        }
        if (connectable == null) {
            connectable = (IConnectable)Platform.getAdapterManager().getAdapter(element, IConnectable.class);
        }
        return connectable;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map) {
            Map dataMap = (Map)data;
            if (dataMap.get(PARAM_ACTION) instanceof String) {
                String stateStr = dataMap.get(PARAM_ACTION).toString().trim();
                this.action = ConnectStateHelper.getConnectAction((String)stateStr);
            }
            if (dataMap.get(PARAM_HANDLE_DIRTY) instanceof String) {
                String value = dataMap.get(PARAM_HANDLE_DIRTY).toString().trim();
                this.handleDirty = Boolean.parseBoolean(value);
            }
        }
    }
}

