/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RefreshResourcesOperation
extends AbstractWorkingCopyOperation {
    public static int REFRESH_CACHE = 0;
    public static int REFRESH_CHANGES = 1;
    public static int REFRESH_ALL = 2;
    protected int depth;
    protected int refreshType;
    protected boolean ignoreNestedProjects;

    public RefreshResourcesOperation(IResource[] resources) {
        this(resources, false);
    }

    public RefreshResourcesOperation(IResource[] resources, boolean ignoreNestedProjects) {
        this(resources, 2, REFRESH_CHANGES, ignoreNestedProjects);
    }

    public RefreshResourcesOperation(IResource[] resources, int depth, int refreshType) {
        this(resources, depth, refreshType, false);
    }

    public RefreshResourcesOperation(IResource[] resources, int depth, int refreshType, boolean ignoreNestedProjects) {
        super("Operation_RefreshResources", SVNMessages.class, resources);
        this.depth = depth;
        this.refreshType = refreshType;
        this.ignoreNestedProjects = ignoreNestedProjects;
    }

    public RefreshResourcesOperation(IResourceProvider provider) {
        this(provider, 2, REFRESH_CHANGES);
    }

    public RefreshResourcesOperation(IResourceProvider provider, int depth, int refreshType) {
        this(provider, depth, refreshType, false);
    }

    public RefreshResourcesOperation(IResourceProvider provider, int depth, int refreshType, boolean ignoreNestedProjects) {
        super("Operation_RefreshResources", SVNMessages.class, provider);
        this.depth = depth;
        this.refreshType = refreshType;
        this.ignoreNestedProjects = ignoreNestedProjects;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = super.getSchedulingRule();
        if (this.ignoreNestedProjects || rule == ResourcesPlugin.getWorkspace().getRoot()) {
            return rule;
        }
        IResource[] resources = this.operableData();
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            ruleSet.add(SVNResourceRuleFactory.INSTANCE.refreshRule(resources[i]));
            ++i;
        }
        return new MultiRule(ruleSet.toArray(new ISchedulingRule[ruleSet.size()]));
    }

    protected IResource[] operableData() {
        IResource[] resources = super.operableData();
        if (this.ignoreNestedProjects) {
            return resources;
        }
        return this.mindNestedProject(resources);
    }

    protected IResource[] mindNestedProject(IResource[] resources) {
        HashSet<Object> resourceSet = new HashSet<Object>();
        int i = 0;
        while (i < resources.length) {
            URI uri = resources[i].getLocationURI();
            if (uri != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IContainer[] iContainerArray = resources[i].getType() != 1 ? root.findContainersForLocationURI(uri) : root.findFilesForLocationURI(uri);
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer resource = iContainerArray[n2];
                    resourceSet.add(resource);
                    ++n2;
                }
                IPath path = FileUtility.getResourcePath(resources[i]);
                IProject[] iProjectArray = root.getProjects();
                int n3 = iProjectArray.length;
                n = 0;
                while (n < n3) {
                    IProject resource = iProjectArray[n];
                    if (path.isPrefixOf(FileUtility.getResourcePath((IResource)resource)) && this.depth != 0) {
                        resourceSet.add(resource);
                    }
                    ++n;
                }
            }
            ++i;
        }
        return resourceSet.toArray(new IResource[resourceSet.size()]);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] withNested;
        IResource[] original = this.operableData();
        if (original.length == 0) {
            return;
        }
        int tDepth = this.depth;
        if (tDepth != 0) {
            boolean allFiles = true;
            int i = 0;
            while (i < original.length) {
                allFiles &= original[i].getType() == 1;
                ++i;
            }
            if (allFiles) {
                tDepth = 0;
            }
        }
        final IResource[] resources = this.depth == 2 ? FileUtility.shrinkChildNodes(original) : original;
        final boolean isPriorToSVN17 = SVNUtility.isPriorToSVN17();
        if (this.refreshType != REFRESH_CACHE) {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < resources.length && !monitor.isCanceled()) {
                        ProgressMonitorUtility.setTaskInfo(monitor, RefreshResourcesOperation.this, resources[i].getName());
                        final IResource resource = resources[i];
                        RefreshResourcesOperation.this.protectStep(new IUnprotectedOperation(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                if (isPriorToSVN17) {
                                    if (resource.getType() != 1 && (this).RefreshResourcesOperation.this.depth != 2) {
                                        RefreshResourcesOperation.this.refreshMetaInfo((IContainer)resource, monitor);
                                    }
                                    if (resource.getType() != 4) {
                                        RefreshResourcesOperation.this.refreshMetaInfo(resource.getParent(), monitor);
                                    }
                                }
                                RefreshResourcesOperation.this.doRefresh(resource, (this).RefreshResourcesOperation.this.depth, monitor);
                            }
                        }, monitor, resources.length);
                        ++i;
                    }
                }
            }, null, 1, monitor);
        }
        if (this.refreshType != REFRESH_CHANGES || !isPriorToSVN17) {
            SVNRemoteStorage.instance().refreshLocalResources(resources, this.depth);
            IResource[] roots = FileUtility.getPathNodes(resources);
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(roots, 0, 1));
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(original, tDepth, 0));
        }
        if (this.ignoreNestedProjects && (withNested = this.mindNestedProject(original)).length != original.length) {
            ProgressMonitorUtility.doTaskScheduledDefault(new RefreshResourcesOperation(withNested, this.depth, this.refreshType), true);
        }
    }

    protected void refreshMetaInfo(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource metaInfo = container.findMember(SVNUtility.getSVNFolderName());
        if (metaInfo != null) {
            this.doRefresh(metaInfo, 2, monitor);
        }
    }

    protected void doRefresh(IResource resource, int depth, IProgressMonitor monitor) throws CoreException {
        try {
            resource.refreshLocal(depth, monitor);
        }
        catch (CoreException ex) {
            if (ex.getStatus() != null && ex.getStatus().toString().indexOf("(.project)") != -1) {
                throw new UnreportableException(SVNMessages.Operation_RefreshResources_DamagedProjectFile);
            }
            throw ex;
        }
    }
}

