/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.operation.BaseFetchOperation;

public class MergeLogEntryCallback
implements BaseFetchOperation.ISVNLogEntryCallbackWithError {
    protected static final int REVISIONS_COUNT_FOR_SAVE = 50000;
    protected IActionOperation op;
    protected int totalWork;
    protected IProgressMonitor monitor;
    protected RepositoryCache repositoryCache;
    protected int currentWork;
    protected int processedRevisionsCount;
    protected int mergeDepth = -1;
    protected SVNLogEntry mergeParentEntry;
    protected Throwable error;

    public MergeLogEntryCallback(IActionOperation op, IProgressMonitor monitor, int totalWork, RepositoryCache repositoryCache) {
        this.op = op;
        this.monitor = monitor;
        this.totalWork = totalWork;
        this.repositoryCache = repositoryCache;
    }

    public void next(SVNLogEntry entry) {
        if (this.error != null) {
            return;
        }
        if (entry.revision == -1L) {
            if (--this.mergeDepth == -1) {
                this.repositoryCache.addMergeInfo(this.mergeParentEntry);
                this.mergeParentEntry = null;
                this.updateSkippedRevisions();
                try {
                    if (++this.processedRevisionsCount % 50000 == 0) {
                        if (this.repositoryCache.isDirty()) {
                            this.repositoryCache.save(this.monitor);
                        }
                        if (this.repositoryCache.getCacheInfo().isDirty()) {
                            this.repositoryCache.getCacheInfo().save();
                        }
                    }
                }
                catch (Throwable e) {
                    this.error = e;
                    this.monitor.setCanceled(true);
                }
            }
        } else {
            if (this.mergeDepth == -1 && !entry.hasChildren()) {
                this.updateSkippedRevisions();
            }
            if (this.mergeDepth == -1) {
                ProgressMonitorUtility.setTaskInfo((IProgressMonitor)this.monitor, (IActionOperation)this.op, (String)SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.LogEntriesCallback_Message, (Object)entry.revision));
                ProgressMonitorUtility.progress((IProgressMonitor)this.monitor, (int)(++this.currentWork), (int)this.totalWork);
            } else if (this.mergeDepth == 0) {
                ProgressMonitorUtility.setTaskInfo((IProgressMonitor)this.monitor, (IActionOperation)this.op, (String)SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.MergeLogEntryCallback_Progress, (Object[])new Object[]{this.mergeParentEntry.revision, entry.revision}));
                this.mergeParentEntry.add(entry);
            }
            if (entry.hasChildren() && this.mergeDepth++ == -1) {
                this.mergeParentEntry = entry;
            }
        }
    }

    protected boolean updateSkippedRevisions() {
        boolean hasRevisionsToProcess = true;
        RepositoryCacheInfo cacheInfo = this.repositoryCache.getCacheInfo();
        long start = cacheInfo.getMergeStartSkippedRevision();
        long end = cacheInfo.getMergeEndSkippedRevision();
        if (start > --end) {
            end = 0L;
            start = 0L;
            hasRevisionsToProcess = false;
        }
        cacheInfo.setMergeSkippedRevisions(start, end);
        return hasRevisionsToProcess;
    }

    public boolean skipRevision() {
        ++this.currentWork;
        this.mergeDepth = -1;
        this.mergeParentEntry = null;
        return this.updateSkippedRevisions();
    }

    public void retryRevision() {
        this.mergeDepth = -1;
        this.mergeParentEntry = null;
    }

    public Throwable getError() {
        return this.error;
    }
}

